<?php
/**
 * Enlight
 *
 * LICENSE
 *
 * This source file is subject to the new BSD license that is bundled
 * with this package in the file LICENSE.txt.
 * It is also available through the world-wide-web at this URL:
 * http://enlight.de/license
 * If you did not receive a copy of the license and are unable to
 * obtain it through the world-wide-web, please send an email
 * to license@shopware.de so we can send you a copy immediately.
 *
 * @category   Enlight
 * @copyright  Copyright (c) 2011, shopware AG (http://www.shopware.de)
 * @license    http://enlight.de/license     New BSD License
 */

/**
 * Enlight
 *
 * This file has been ported from Zend Framework 1 into the Enlight Framework,
 * to allow the removal of the original library from Shopware.
 *
 * This porting is in full compliance with the New BSD License
 * under which the original file is distributed.
 *
 * @category   Enlight
 * @package    Enlight_Config
 */
abstract class Enlight_Config_Writer_Writer
{
    /**
     * Option keys to skip when calling setOptions()
     *
     * @var array
     */
    protected $_skipOptions = array(
        'options'
    );

    /**
     * Config object to write
     *
     * @var Enlight_Config_BaseConfig
     */
    protected $_config = null;

    /**
     * Create a new adapter
     *
     * $options can only be passed as array or be omitted
     *
     * @param null|array $options
     */
    public function __construct(array $options = null)
    {
        if (is_array($options)) {
            $this->setOptions($options);
        }
    }

    /**
     * Set options via a Enlight_Config_BaseConfig instance
     *
     * @param  Enlight_Config_BaseConfig $config
     * @return Enlight_Config_Writer_Writer
     */
    public function setConfig(Enlight_Config_BaseConfig $config)
    {
        $this->_config = $config;

        return $this;
    }

    /**
     * Set options via an array
     *
     * @param  array $options
     * @return Enlight_Config_Writer_Writer
     */
    public function setOptions(array $options)
    {
        foreach ($options as $key => $value) {
            if (in_array(strtolower($key), $this->_skipOptions)) {
                continue;
            }

            $method = 'set' . ucfirst($key);
            if (method_exists($this, $method)) {
                $this->$method($value);
            }
        }

        return $this;
    }

    /**
     * Write a Enlight_Config_BaseConfig object to it's target
     *
     * @return void
     */
    abstract public function write();
}
