<?php
class Migrations_Migration147 Extends Shopware\Components\Migrations\AbstractMigration
{
    public function up($modus)
    {
        $sql = <<<'EOD'
            SET @parent = (SELECT `id` FROM `s_core_config_elements` WHERE `name` = 'refererCheck');
            INSERT IGNORE INTO `s_core_config_element_translations` (`id` ,`element_id` ,`locale_id` ,`label` ,`description`)
                VALUES (NULL , @parent, '2', 'Activate referrer check', NULL);


            SET @parent = (SELECT id FROM s_core_config_forms WHERE name = 'Passwörter' AND parent_id=@help_parent);
            INSERT IGNORE INTO `s_core_config_form_translations` (`id`, `form_id`, `locale_id`, `label`, `description`)
                VALUES (NULL, @parent, '2', 'Passwords', NULL);

            SET @elementId = (SELECT id FROM s_core_config_elements WHERE name = 'defaultPasswordEncoder');
            INSERT IGNORE INTO s_core_config_element_translations (element_id, locale_id, label, description)
                VALUES (@elementId, 2, 'Password algorithm', 'With which algorithm should the password be encrypted?');
            SET @elementId = (SELECT id FROM s_core_config_elements WHERE name = 'liveMigration');
            INSERT IGNORE INTO s_core_config_element_translations (element_id, locale_id, label, description)
                VALUES (@elementId, 2, 'Live migration', 'Should available user passwords be rehashed with other algorithms on next login? This is done automatically in the background, so that passwords can be gradually converted to a new algorithm.');
            SET @elementId = (SELECT id FROM s_core_config_elements WHERE name = 'bcryptCost');
            INSERT IGNORE INTO s_core_config_element_translations (element_id, locale_id, label, description)
                VALUES (@elementId, 2, 'Bcrypt iterations', 'The higher the number of iterations, the more difficult it is for a potential attacker to calculate the clear-text password for the encrypted password.');
            SET @elementId = (SELECT id FROM s_core_config_elements WHERE name = 'sha256iterations');
            INSERT IGNORE INTO s_core_config_element_translations (element_id, locale_id, label, description)
                VALUES (@elementId, 2, 'Sha256 iterations', 'The higher the number of iterations, the more difficult it is for a potential attacker to calculate the clear-text password for the encrypted password.');

            UPDATE `s_core_config_forms` SET `label` = 'Frontend cache (HTTP cache)' WHERE name = 'HttpCache' and label = 'Frontendcache (HttpCache)';

            SET @elementId = (SELECT id FROM s_core_config_elements WHERE name = 'admin');
            INSERT IGNORE INTO s_core_config_element_translations (element_id, locale_id, label, description)
                VALUES (@elementId, 2, 'Admin view', 'Deactivate cache for item preview in express checkout');

            SET @elementId = (SELECT id FROM s_core_config_elements WHERE name = 'cacheControllers');
            INSERT IGNORE INTO s_core_config_element_translations (element_id, locale_id, label, description)
                VALUES (@elementId, 2, 'Controller cache timeouts', NULL);

            SET @elementId = (SELECT id FROM s_core_config_elements WHERE name = 'noCacheControllers');
            INSERT IGNORE INTO s_core_config_element_translations (element_id, locale_id, label, description)
                VALUES (@elementId, 2, 'Skip caching for controllers / tags', NULL);

            SET @elementId = (SELECT id FROM s_core_config_elements WHERE name = 'proxy');
            INSERT IGNORE INTO s_core_config_element_translations (element_id, locale_id, label, description)
                VALUES (@elementId, 2, 'Alternative proxy URL', 'Prepend "http://" to HTTP proxy links');

            SET @elementId = (SELECT id FROM s_core_config_elements WHERE name = 'proxyPrune');
            INSERT IGNORE INTO s_core_config_element_translations (element_id, locale_id, label, description)
                VALUES (@elementId, 2,  'Activate cache clearing', 'Enable automatic cache clearing.');

            SET @elementId = (SELECT id FROM s_core_config_forms WHERE name = 'TrustedShop');
            INSERT INTO `s_core_config_form_translations` (`form_id`, `locale_id`, `label`, `description`) VALUES
                (@elementId, 2, 'Trusted shops', '\r\n<style type="text/css">\r\n    body { padding: 10px; }\r\n    h2 { margin: 0 0 .5em; }\r\n    p { margin: 0 0 1.5em }\r\n    .logo { margin: 1em; }\r\n    .logo img { display: block; width: 300px; height: 140px; margin: 0 auto }\r\n</style>\r\n\r\n<div class="logo">\r\n    <img src=''data:image/gif;base64,R0lGODlhLAGMAOZSAP///0xLTszMzAFotsxmM//MZuCFZ2aZzP735ZmZmfvhkv/MzNptSfrr5uDf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\r\nOw=='' alt="Trusted Shops Logo">\r\n</div>\r\n\r\n<div class="info">\r\n	<h2>Seal of approval and buyer protection</h2>\r\n	<p>\r\n		Trusted Shops certifies online shops by carefully checking a SET of quality criteria before awarding the European trust mark. With the combination of Trusted Shop\'s money-back guarantee and the seller rating system you are able to order online with confidence.\r\n	</p>\r\n\r\n\r\n	<h2>More trust means more turnover!</h2>\r\n	<p>\r\n		The Trusted Shops Seal of Approval is optimal for building the trust of your online customers. Confidence increases the readiness of your customers to buy from you.\r\n	</p>\r\n\r\n	<h2>Fewer abandoned shopping carts</h2>\r\n	<p>\r\n		You offer your online customers a strong argument: the Trusted Shops Buyer Protection. With this additional security, fewer purchases will be cancelled.\r\n	</p>\r\n\r\n	<h2>Profitable and sustainable customer relationships</h2>\r\n	<p>\r\n		The Trusted Shops Seal of Approval with Buyer Protection is a sustainable quality feature for safe shopping on the Web for many online shoppers. First-time buyers become regular customers.\r\n	</p>\r\n	<div class="register">\r\n		<a class="button" href="http://www.trustedshops.de/shopbetreiber/index.html?et_cid=14&et_lid=29818" target="_blank">\r\n			Get informed and sign up!\r\n		</a>\r\n	</div>\r\n</div>');

            SET @parent = (SELECT `id` FROM `s_core_config_elements` WHERE `name` = 'DummyPluginUrl');
            INSERT IGNORE INTO `s_core_config_element_translations` (`id` ,`element_id` ,`locale_id` ,`label` ,`description`)
                VALUES (NULL , @parent, '2', 'Dummy plugin download URL', NULL);

            UPDATE s_core_config_form_translations SET label = 'Frontend' WHERE label = 'Storefront' AND locale_id = 2 AND form_id = (SELECT id FROM s_core_config_forms WHERE name = 'Frontend');
            UPDATE s_core_config_form_translations SET label = 'Store API' WHERE label = 'StoreApi' AND locale_id = 2 AND form_id = (SELECT id FROM s_core_config_forms WHERE name = 'StoreApi');
            UPDATE s_core_config_form_translations SET label = 'Email settings' WHERE description = 'e-mail settings' AND locale_id = 2 AND form_id = (SELECT id FROM s_core_config_forms WHERE name = 'Frontend60');
            UPDATE s_core_config_form_translations SET label = 'Cron jobs' WHERE description = 'Cronjobs' AND locale_id = 2 AND form_id = (SELECT id FROM s_core_config_forms WHERE name = 'CronJob');
            UPDATE s_core_config_form_translations SET label = 'Other VAT rates' WHERE label = 'Other VAT-rates' AND locale_id = 2 AND form_id = (SELECT id FROM s_core_config_forms WHERE name = 'Product35');
            UPDATE s_core_config_form_translations SET label = 'Statistics' WHERE description = 'Statstics' AND locale_id = 2 AND form_id = (SELECT id FROM s_core_config_forms WHERE name = 'Statistics');

            UPDATE s_core_config_element_translations SET label = 'Automatic suggestion of article number' WHERE label = 'Automatical suggestion of article number' AND locale_id = 2 AND element_id = (SELECT id FROM s_core_config_elements WHERE name = 'backendautoordernumber');
            UPDATE s_core_config_element_translations SET label = 'Font color code (R,G,B)' WHERE label = 'Font color Captcha (R,G,B)' AND locale_id = 2 AND element_id = (SELECT id FROM s_core_config_elements WHERE name = 'captchaColor');
            UPDATE s_core_config_element_translations SET label = 'Send automatic reminder of article evaluation' WHERE label = 'Send automatical reminder of article evaluation' AND locale_id = 2 AND element_id = (SELECT id FROM s_core_config_elements WHERE name = 'votesendcalling');
            UPDATE s_core_config_element_translations SET description = 'Remind buyer of article evaluation via email after purchase' WHERE description = 'Remind buyer of article evaluation via e-mail after purchase ' AND locale_id = 2 AND element_id = (SELECT id FROM s_core_config_elements WHERE name = 'votesendcalling');
            UPDATE s_core_config_element_translations SET label = 'Days until the reminder email will be sent' WHERE label = 'Days until the reminder e-mail will be sent' AND locale_id = 2 AND element_id = (SELECT id FROM s_core_config_elements WHERE name = 'votecallingtime');
            UPDATE s_core_config_element_translations SET label = 'Hide shopping cart with e-mail notification' WHERE label = 'Hide shopping cart with e-mail notification' AND locale_id = 2 AND element_id = (SELECT id FROM s_core_config_elements WHERE name = 'deactivatebasketonnotification');
            UPDATE s_core_config_element_translations SET description = 'Hide shopping cart with activated email notification and non-existing stock level' WHERE description = 'Hide shopping cart with activated e-mail notification and non-existing stock level' AND locale_id = 2 AND element_id = (SELECT id FROM s_core_config_elements WHERE name = 'deactivatebasketonnotification');
            UPDATE s_core_config_element_translations SET label = 'Email address must be entered twice.' WHERE label = 'E-mail address must be entered twice.' AND locale_id = 2 AND element_id = (SELECT id FROM s_core_config_elements WHERE name = 'doubleemailvalidation');
            UPDATE s_core_config_element_translations SET description = 'Email address must be entered twice in order to avoid typing errors' WHERE description = 'E-mail address must be entered twice in order to avoid typing errors' AND locale_id = 2 AND element_id = (SELECT id FROM s_core_config_elements WHERE name = 'doubleemailvalidation');
            UPDATE s_core_config_element_translations SET label = 'Make IP address anonymous' WHERE label = 'anonymize IP address' AND locale_id = 2 AND element_id = (SELECT id FROM s_core_config_elements WHERE name = 'anonymize_ip');
            UPDATE s_core_config_element_translations SET label = 'Designation for percentual surcharge on payment method' WHERE label = 'Designation for percental surcharge on payment method ' AND locale_id = 2 AND element_id = (SELECT id FROM s_core_config_elements WHERE name = 'paymentsurchargeadd');
            UPDATE s_core_config_element_translations SET label = 'Designation percentual deduction on payment method' WHERE label = 'Designation percental deduction on payment method' AND locale_id = 2 AND element_id = (SELECT id FROM s_core_config_elements WHERE name = 'paymentsurchargedev');
            UPDATE s_core_config_element_translations SET label = 'Order status - Changes CC address' WHERE label = 'Order status - Chnages CC address' AND locale_id = 2 AND element_id = (SELECT id FROM s_core_config_elements WHERE name = 'orderstatemailack');
            UPDATE s_core_config_element_translations SET label = 'Shop owner email' WHERE label = 'Shop owner e-mail' AND locale_id = 2 AND element_id = (SELECT id FROM s_core_config_elements WHERE name = 'mail');
            UPDATE s_core_config_element_translations SET label = 'Min. length of password (registration)' WHERE label = 'Min. lenth of password (registration)' AND locale_id = 2 AND element_id = (SELECT id FROM s_core_config_elements WHERE name = 'minpassword');

            UPDATE s_core_snippets SET value = 'Your email address' WHERE value = 'Your e-mail address' AND name = 'LoginLabelMail' AND localeID = 2 AND namespace = 'frontend/account/ajax_login';
            UPDATE s_core_snippets SET value = 'Your email address' WHERE value = 'Your e-mail address' AND name = 'BlogLabelMail' AND localeID = 2 AND namespace = 'frontend/blog/comments';
            UPDATE s_core_snippets SET value = 'Your email address' WHERE value = 'Your e-mail address' AND name = 'DetailCommentLabelMail' AND localeID = 2 AND namespace = 'frontend/detail/comment';
            UPDATE s_core_snippets SET value = 'Your email address' WHERE value = 'Your e-mail address' AND name = 'DetailNotifyLabelMail' AND localeID = 2 AND namespace = 'frontend/plugins/notification/index';
            UPDATE s_core_snippets SET value = 'Your email address' WHERE value = 'Your e-mail address' AND name = 'IndexFooterNewsletterValue' AND localeID = 2 AND namespace = 'frontend/index/menu_footer';
            UPDATE s_core_snippets SET value = 'Your email address:' WHERE value = 'Your e-mail address:' AND name = 'PasswordLabelMail' AND localeID = 2 AND namespace = 'frontend/account/password';
            UPDATE s_core_snippets SET value = 'Your email address:' WHERE value = 'Your e-mail address:' AND name = 'LoginLabelMail' AND localeID = 2 AND namespace = 'frontend/account/login';
            UPDATE s_core_snippets SET value = 'Your email address*:' WHERE value = 'Your e-mail address*:' AND name = 'RegisterLabelMail' AND localeID = 2 AND namespace = 'frontend/register/personal_fieldset';
            UPDATE s_core_snippets SET value = 'Your email address*:' WHERE value = 'Your e-mail address*:' AND name = 'sNewsletterLabelMail' AND localeID = 2 AND namespace = 'frontend/newsletter/index';
            UPDATE s_core_snippets SET value = 'Your email address*:' WHERE value = 'Your e-mail address*:' AND name = 'TellAFriendLabelMail' AND localeID = 2 AND namespace = 'frontend/tellafriend/index';
            UPDATE s_core_snippets SET value = 'Reenter your email address*:' WHERE value = 'Reenter your e-mail address*:' AND name = 'RegisterLabelMailConfirmation' AND localeID = 2 AND namespace = 'frontend/register/personal_fieldset';
            UPDATE s_core_snippets SET value = 'Subscribe now to our regularly released newsletter and be informed about the latest products and special offers. You will be able to unsubscribe at any time using this website or the link included in the newsletter.' WHERE value = 'Subscribe now to our regulary released newsletter and be informed about the latest products and special offers. You are able to unsubscribe via link included in this e-mail or via website at any time. ' AND name = 'sNewsletterInfo' AND localeID = 2 AND namespace = 'frontend/newsletter/index';
            UPDATE s_core_snippets SET value = 'You already have a customer account' WHERE value = 'You already have a customer accoount' AND name = 'LoginHeaderExistingCustomer' AND localeID = 2 AND namespace = 'frontend/account/login';
            UPDATE s_core_snippets SET value = 'Log in with your email address and your password' WHERE value = 'Log in with your e-mail address and your password' AND name = 'LoginHeaderFields' AND localeID = 2 AND namespace = 'frontend/account/login';
            UPDATE s_core_snippets SET value = 'We have sent you the order confirmation by email.' WHERE value = 'We have sent you the order confirmation by e-mail.' AND name = 'FinishInfoConfirmationMail' AND localeID = 2 AND namespace = 'frontend/checkout/finish';
            UPDATE s_core_snippets SET value = 'Thank you for submitting your evaluation. You will receive a confirmation email in just a few minutes. Please confirm the link including in the email in order to release your evaluation.' WHERE value = 'Thank you for submitting your evaluation. You will receive a confirmation e-mail in just a few minutes. Please confirm the link including in the email in order to release your evaluation.' AND name = 'BlogInfoSuccessOptin' AND localeID = 2 AND namespace = 'frontend/blog/comments';
            UPDATE s_core_snippets SET value = 'Please enter a valid email address' WHERE value = 'Please enter a valid e-mail address' AND name = 'DetailNotifyInfoErrorMail' AND localeID = 2 AND namespace = 'frontend/plugins/notification/index';
            UPDATE s_core_snippets SET value = 'Please enter a valid email address' WHERE value = 'Please enter a valid e-mail address' AND name = 'RegisterAjaxEmailNotValid' AND localeID = 2 AND namespace = 'frontend';
            UPDATE s_core_snippets SET value = 'Please enter a valid email address' WHERE value = 'Please enter a valid e-mail address' AND name = 'NewsletterFailureInvalid' AND localeID = 2 AND namespace = 'frontend/account/internalMessages';
            UPDATE s_core_snippets SET value = 'Please confirm the link contained in the email that you have just received. We will inform you as soon as the product is available again. ' WHERE value = 'Please confirm the link contained in the e-mail that you have just received. We will inform you as soon as the product is available again. ' AND name = 'DetailNotifyInfoSuccess' AND localeID = 2 AND namespace = 'frontend/plugins/notification/index';
            UPDATE s_core_snippets SET value = 'We will activate your account after verification. You will then receive a confirmation email. <br /> From now on, you will be displayed the merchant purchase prices on the item and overview pages.' WHERE value = 'We will activate your account after verification. You will then receive a confirmation e-mail. <br /> From now on, you will be displayed the merchant purchase prices on the product- and overview pages.' AND name = 'RegisterInfoSupplier7' AND localeID = 2 AND namespace = 'frontend/register/index';
            UPDATE s_core_snippets SET value = 'The email addresses do not match' WHERE value = 'The e-mail addresses do not match' AND name = 'RegisterAjaxEmailNotEqual' AND localeID = 2 AND namespace = 'frontend';
            UPDATE s_core_snippets SET value = 'The email addresses do not match' WHERE value = 'The e-mail addresses do not match' AND name = 'MailFailureNotEqual' AND localeID = 2 AND namespace = 'frontend/account/internalMessages';
            UPDATE s_core_snippets SET value = 'This email address is already registered' WHERE value = 'This e-mail address is already registered.' AND name = 'RegisterAjaxEmailForgiven' AND localeID = 2 AND namespace = 'frontend';
            UPDATE s_core_snippets SET value = 'This email address is already registered' WHERE value = 'This e-mail address is already registered' AND name = 'MailFailureAlreadyRegistered' AND localeID = 2 AND namespace = 'frontend/account/internalMessages';
            UPDATE s_core_snippets SET value = 'Thank you! We have sent a confirmation email. All you need to do is click the link in the email in order to confirm your registration.' WHERE value = 'Thank you! We have sent a confirmation e-mail. All you need to do is click the link in the e-mail in order to confirm your registration.' AND name = 'sMailConfirmation' AND localeID = 2 AND namespace = 'frontend';
            UPDATE s_core_snippets SET value = 'Login with your email address and your password' WHERE value = 'Login with your e-Mail address and your password' AND name = 'LoginTextExisting' AND localeID = 2 AND namespace = 'frontend/account/ajax_login';
            UPDATE s_core_snippets SET value = 'Change email' WHERE value = 'Change e-mail' AND name = 'AccountLinkChangeMail' AND localeID = 2 AND namespace = 'frontend/account/index';
            UPDATE s_core_snippets SET value = 'New email address' WHERE value = 'New e-mail address' AND name = 'AccountLabelNewMail' AND localeID = 2 AND namespace = 'frontend/account/index';
            UPDATE s_core_snippets SET value = 'Email confirmation' WHERE value = 'e-mail confirmation' AND name = 'AccountLabelMail' AND localeID = 2 AND namespace = 'frontend/account/index';
            UPDATE s_core_snippets SET value = 'This email address could not be found' WHERE value = 'This e-mail address could not be found' AND name = 'NewsletterFailureNotFound' AND localeID = 2 AND namespace = 'frontend/account/internalMessages';
            UPDATE s_core_snippets SET value = 'Your email address has been deleted.' WHERE value = 'Your e-mail address has been deleted.' AND name = 'NewsletterMailDeleted' AND localeID = 2 AND namespace = 'frontend/account/internalMessages';
            UPDATE s_core_snippets SET value = 'Please enter an email address' WHERE value = 'Please enter an e-mail address' AND name = 'NewsletterFailureMail' AND localeID = 2 AND namespace = 'frontend/account/internalMessages';
            UPDATE s_core_snippets SET value = 'Please enter a valid email address' WHERE value = 'Please enter a valid E-Mail address' AND name = 'MailFailure' AND localeID = 2 AND namespace = 'frontend/account/internalMessages';
            UPDATE s_core_snippets SET value = 'Please enter your email address' WHERE value = 'Please enter your e-mail address' AND name = 'ErrorForgotMail' AND localeID = 2 AND namespace = 'frontend/account/password';
            UPDATE s_core_snippets SET value = 'Email address unknown' WHERE value = 'e-mail address unknown' AND name = 'ErrorForgotMailUnknown' AND localeID = 2 AND namespace = 'frontend/account/password';
            UPDATE s_core_snippets SET value = 'New email address' WHERE value = 'New e-mail address' AND name = 'AccountLabelNewMail' AND localeID = 2 AND namespace = 'frontend/account/index';
            UPDATE s_core_snippets SET value = 'Email confirmation' WHERE value = 'e-mail confirmation' AND name = 'AccountLabelMail' AND localeID = 2 AND namespace = 'frontend/account/index';
            UPDATE s_core_snippets SET value = 'An error has occurred while validating your email address. Possibly your email address has already been validated.' WHERE value = 'An error has occurred while validating your e-mail address. Possibly your email address has already been validated.' AND name = 'DetailNotifyInfoInvalid' AND localeID = 2 AND namespace = 'frontend/plugins/notification/index';

            -- 59
            UPDATE s_core_translations SET objectdata = 'a:546:{s:15:"sPaymentESDInfo";a:1:{s:5:"value";s:69:"Purchase of direct downloads is only possible by debit or credit card";}s:8:"sAGBText";a:1:{s:5:"value";s:181:"I have read the <a href="{$sBasefile}?sViewport=custom&cCUSTOM=4" title="Terms"><span style="text-decoration:underline;">Terms</span></a> of your shop and agree with their coverage.";}s:10:"sOrderInfo";a:1:{s:5:"value";s:112:"(Optionaler Freitext)If you pay debit or with your creditcard your bank account will be charged after five days.";}s:15:"sRegister_right";a:1:{s:5:"value";s:183:"<p>\nInsert your right of withdrawl here.\n<br /><br />\n<a href="{$sBasefile}?sViewport=custom&cCUSTOM=8" title="Right of Withdrawl">more informations to your right of withdrawl</a></p>";}s:28:"sNewsletterOptionUnsubscribe";a:1:{s:5:"value";s:26:"unsubscribe the newsletter";}s:26:"sNewsletterOptionSubscribe";a:1:{s:5:"value";s:24:"subscribe the newsletter";}s:15:"sNewsletterInfo";a:1:{s:5:"value";s:151:"Subsribe and get our newsletter.<br />\nOf course you can cancel this newsletter any time. Use the hyperlink in your eMail or visit this website again. ";}s:17:"sNewsletterButton";a:1:{s:5:"value";s:4:"Save";}s:20:"sNewsletterLabelMail";a:1:{s:5:"value";s:19:"Your eMail-address:";}s:22:"sNewsletterLabelSelect";a:1:{s:5:"value";s:10:"I want to:";}s:17:"sInfoEmailDeleted";a:1:{s:5:"value";s:32:"Your eMail-address were deleted.";}s:19:"sInfoEmailRegiested";a:1:{s:5:"value";s:35:"Thanks. We added your eMail-address";}s:16:"sErrorEnterEmail";a:1:{s:5:"value";s:31:"Please specify an email address";}s:16:"sErrorForgotMail";a:1:{s:5:"value";s:31:"Please enter your email address";}s:10:"sDelivery1";a:1:{s:5:"value";s:47:"Ready for shipment,<br/>\nShipping time 1-3 days";}s:17:"sErrorLoginActive";a:1:{s:5:"value";s:84:"Your account has been disabled, to clarify please get in contact with us personally!";}s:27:"sAccountACommentisdeposited";a:1:{s:5:"value";s:20:"A Comment is leaved!";}s:15:"sAccountArticle";a:1:{s:5:"value";s:7:"Article";}s:22:"sAccountBillingAddress";a:1:{s:5:"value";s:15:"Billing Address";}s:15:"sAccountComment";a:1:{s:5:"value";s:11:"Annotation:";}s:16:"sAccountcompany ";a:1:{s:5:"value";s:7:"Company";}s:16:"sAccountDownload";a:1:{s:5:"value";s:8:"Download";}s:19:"sAccountDownloadNow";a:1:{s:5:"value";s:12:"Download now";}s:29:"sAccountDownloadssortedbydate";a:1:{s:5:"value";s:29:"Your downloads sorted by date";}s:24:"sAccountErrorhasoccurred";a:1:{s:5:"value";s:22:"An Error has occurred!";}s:12:"sAccountFree";a:1:{s:5:"value";s:4:"FREE";}s:12:"sAccountfrom";a:1:{s:5:"value";s:5:"From:";}s:18:"sAccountgrandtotal";a:1:{s:5:"value";s:12:"Grand total:";}s:18:"sAccountIwanttoget";a:1:{s:5:"value";s:31:"Yes, I want to receive the free";}s:23:"sAccountmethodofpayment";a:1:{s:5:"value";s:15:"Choosen Payment";}s:14:"sAccountmodify";a:1:{s:5:"value";s:6:"Modify";}s:10:"sAccountMr";a:1:{s:5:"value";s:2:"Mr";}s:10:"sAccountMs";a:1:{s:5:"value";s:2:"Ms";}s:19:"sAccountNewPassword";a:1:{s:5:"value";s:14:"New password*:";}s:26:"sAccountnewslettersettings";a:1:{s:5:"value";s:24:"Your Newsletter settings";}s:14:"sAccountNumber";a:1:{s:5:"value";s:8:"Quantity";}s:21:"sAccountOrdercanceled";a:1:{s:5:"value";s:19:"Order was cancelled";}s:27:"sAccountOrderhasbeenshipped";a:1:{s:5:"value";s:22:"Order has been shipped";}s:23:"sAccountOrderinprogress";a:1:{s:5:"value";s:17:"Order in progress";}s:28:"sAccountOrdernotvetprocessed";a:1:{s:5:"value";s:32:"Order has not been processed yet";}s:19:"sAccountOrdernumber";a:1:{s:5:"value";s:12:"Ordernumber:";}s:29:"sAccountOrderpartiallyshipped";a:1:{s:5:"value";s:27:"Order was partially shipped";}s:26:"sAccountOrderssortedbydate";a:1:{s:5:"value";s:21:"Orders sorted by date";}s:18:"sAccountOrderTotal";a:1:{s:5:"value";s:12:"Order total:";}s:23:"sAccountPackagetracking";a:1:{s:5:"value";s:17:"Package tracking:";}s:12:"sAccountplus";a:1:{s:5:"value";s:4:"plus";}s:22:"sAccountRepeatpassword";a:1:{s:5:"value";s:17:"Repeat password*:";}s:16:"sAccountShipping";a:1:{s:5:"value";s:15:"Shipping costs:";}s:23:"sAccountshippingaddress";a:1:{s:5:"value";s:16:"Shipping address";}s:21:"sAccountthenewsletter";a:1:{s:5:"value";s:11:"Newsletter!";}s:13:"sAccountTotal";a:1:{s:5:"value";s:5:"Total";}s:17:"sAccountUnitprice";a:1:{s:5:"value";s:10:"Unit price";}s:22:"sAccountYouraccessdata";a:1:{s:5:"value";s:16:"Your access data";}s:24:"sAccountYouremailaddress";a:1:{s:5:"value";s:20:"Your email address*:";}s:24:"sAccountyourSerialnumber";a:1:{s:5:"value";s:19:"Your Serial Number:";}s:26:"sAccountyourSerialnumberto";a:1:{s:5:"value";s:21:"Your Serial Number to";}s:19:"sAjaxcomparearticle";a:1:{s:5:"value";s:16:"Compared Article";}s:18:"sAjaxdeletecompare";a:1:{s:5:"value";s:14:"Delete Compare";}s:17:"sAjaxstartcompare";a:1:{s:5:"value";s:13:"Start Compare";}s:9:"sArticle1";a:1:{s:5:"value";s:12:"1 (very bad)";}s:10:"sArticle10";a:1:{s:5:"value";s:14:"10 (excellent)";}s:9:"sArticle2";a:1:{s:5:"value";s:1:"2";}s:9:"sArticle3";a:1:{s:5:"value";s:1:"3";}s:9:"sArticle4";a:1:{s:5:"value";s:1:"4";}s:9:"sArticle5";a:1:{s:5:"value";s:1:"5";}s:9:"sArticle6";a:1:{s:5:"value";s:1:"6";}s:9:"sArticle7";a:1:{s:5:"value";s:1:"7";}s:9:"sArticle8";a:1:{s:5:"value";s:1:"8";}s:9:"sArticle9";a:1:{s:5:"value";s:1:"9";}s:19:"sArticleaccessories";a:1:{s:5:"value";s:11:"Accessories";}s:19:"sArticleaddtobasked";a:1:{s:5:"value";s:11:"add to cart";}s:20:"sArticleaddtonotepad";a:1:{s:5:"value";s:16:"Add to favorites";}s:21:"sArticleafterageckeck";a:1:{s:5:"value";s:52:"Attention! Delivery only after successful age check!";}s:24:"sArticleallmanufacturers";a:1:{s:5:"value";s:22:"Show all manufacturers";}s:14:"sArticleamount";a:1:{s:5:"value";s:9:"Quantity:";}s:11:"sArticleand";a:1:{s:5:"value";s:3:"and";}s:22:"sArticlearticleperpage";a:1:{s:5:"value";s:16:"Article per page";}s:21:"sArticleavailableasan";a:1:{s:5:"value";s:34:"Available as an immediate download";}s:26:"sArticleavailabledownloads";a:1:{s:5:"value";s:20:"Available downloads:";}s:21:"sArticleAvailablefrom";a:1:{s:5:"value";s:12:"Available as";}s:26:"sArticleavailableimmediate";a:1:{s:5:"value";s:34:"Available as an immediate download";}s:12:"sArticleback";a:1:{s:5:"value";s:4:"Back";}s:20:"sArticleblockpricing";a:1:{s:5:"value";s:13:"Block pricing";}s:10:"sArticleby";a:1:{s:5:"value";s:3:"By:";}s:24:"sArticlechoosefirstexecu";a:1:{s:5:"value";s:32:"Attention! Choose version first!";}s:22:"sArticlecollectvoucher";a:1:{s:5:"value";s:34:"Tell a friend and catch a voucher!";}s:15:"sArticleCompare";a:1:{s:5:"value";s:7:"Compare";}s:23:"sArticlecustomerreviews";a:1:{s:5:"value";s:20:"Customer reviews for";}s:17:"sArticledatasheet";a:1:{s:5:"value";s:9:"Datasheet";}s:12:"sArticledays";a:1:{s:5:"value";s:4:"Days";}s:24:"sArticledaysshippingfree";a:1:{s:5:"value";s:14:"Shipping free!";}s:20:"sArticledeliverytime";a:1:{s:5:"value";s:13:"Shipping time";}s:19:"sArticledescription";a:1:{s:5:"value";s:11:"Description";}s:16:"sArticledownload";a:1:{s:5:"value";s:8:"Download";}s:19:"sArticleeightpoints";a:1:{s:5:"value";s:8:"8 Points";}s:23:"sArticleenterthenumbers";a:1:{s:5:"value";s:50:"Please enter the numbers in the following text box";}s:27:"sArticlefilloutallredfields";a:1:{s:5:"value";s:34:"Please fill in all required fields";}s:18:"sArticlefivepoints";a:1:{s:5:"value";s:8:"5 Points";}s:18:"sArticlefourpoints";a:1:{s:5:"value";s:8:"4 Points";}s:20:"sArticlefreeshipping";a:1:{s:5:"value";s:14:"Shipping Free!";}s:12:"sArticlefrom";a:1:{s:5:"value";s:4:"from";}s:26:"sArticlefurtherinformation";a:1:{s:5:"value";s:19:"further information";}s:19:"sArticlegetavoucher";a:1:{s:5:"value";s:16:"is your voucher*";}s:20:"sArticlehighestprice";a:1:{s:5:"value";s:13:"Highest Price";}s:12:"sArticleincl";a:1:{s:5:"value";s:5:"incl.";}s:19:"sArticleinthebasket";a:1:{s:5:"value";s:24:"add to you shopping cart";}s:17:"sArticleitemtitle";a:1:{s:5:"value";s:19:"Article description";}s:16:"sArticlelanguage";a:1:{s:5:"value";s:9:"Language:";}s:13:"sArticlelegal";a:1:{s:5:"value";s:5:"legal";}s:14:"sArticlelooked";a:1:{s:5:"value";s:11:"Last viewed";}s:19:"sArticlelowestprice";a:1:{s:5:"value";s:12:"Lowest Price";}s:19:"sArticlemainarticle";a:1:{s:5:"value";s:12:"Main article";}s:21:"sArticlematchingitems";a:1:{s:5:"value";s:27:"Frequently Bought Together:";}s:23:"sArticleMoreinformation";a:1:{s:5:"value";s:20:"Get more information";}s:28:"sArticlemoreinformationabout";a:1:{s:5:"value";s:26:"Get more information about";}s:11:"sArticlenew";a:1:{s:5:"value";s:3:"NEW";}s:12:"sArticlenext";a:1:{s:5:"value";s:4:"Next";}s:18:"sArticleninepoints";a:1:{s:5:"value";s:8:"9 Points";}s:17:"sArticlenoPicture";a:1:{s:5:"value";s:20:"No picture available";}s:10:"sArticleof";a:1:{s:5:"value";s:2:"by";}s:16:"sArticleonepoint";a:1:{s:5:"value";s:7:"1 Point";}s:19:"sArticleonesiteback";a:1:{s:5:"value";s:13:"One Site back";}s:22:"sArticleonesiteforward";a:1:{s:5:"value";s:16:"One Site forward";}s:20:"sArticleonthenotepad";a:1:{s:5:"value";s:16:"add to favorites";}s:19:"sArticleordernumber";a:1:{s:5:"value";s:10:"Order No.:";}s:23:"sArticleotherarticlesof";a:1:{s:5:"value";s:22:"Other articles made by";}s:20:"sArticleourcommenton";a:1:{s:5:"value";s:13:"Our review to";}s:11:"sArticleout";a:1:{s:5:"value";s:3:"out";}s:16:"sArticleoverview";a:1:{s:5:"value";s:8:"Overview";}s:20:"sArticlepleasechoose";a:1:{s:5:"value";s:16:"Please choose...";}s:25:"sArticlepleasecompleteall";a:1:{s:5:"value";s:34:"Please fill in all required fields";}s:20:"sArticlepleaseselect";a:1:{s:5:"value";s:16:"Please choose...";}s:18:"sArticlepopularity";a:1:{s:5:"value";s:11:"Bestselling";}s:14:"sArticleprices";a:1:{s:5:"value";s:6:"Prices";}s:18:"sArticleproductsof";a:1:{s:5:"value";s:16:"Products made by";}s:29:"sArticlequestionsaboutarticle";a:1:{s:5:"value";s:22:"Questions for article?";}s:22:"sArticlerecipientemail";a:1:{s:5:"value";s:22:"Receiver email address";}s:17:"sArticlerecommend";a:1:{s:5:"value";s:36:": tell a friend and catch a voucher!";}s:27:"sArticlerecommendandvoucher";a:1:{s:5:"value";s:32:"Tell a friend and get a voucher!";}s:16:"sArticlereleased";a:1:{s:5:"value";s:19:"unrated (universal)";}s:30:"sArticlereleasedafterverificat";a:1:{s:5:"value";s:44:"Reviews will be released after verification.";}s:19:"sArticlereleasedate";a:1:{s:5:"value";s:12:"Release Date";}s:27:"sArticlereleasedfrom12years";a:1:{s:5:"value";s:20:"Restricted 12 years+";}s:27:"sArticlereleasedfrom16years";a:1:{s:5:"value";s:20:"Restricted 16 years+";}s:27:"sArticlereleasedfrom18years";a:1:{s:5:"value";s:20:"Restricted 18 years+";}s:26:"sArticlereleasedfrom6years";a:1:{s:5:"value";s:24:"Restricted from 6 years+";}s:14:"sArticleReview";a:1:{s:5:"value";s:16:"Costumer Review:";}s:15:"sArticlereview1";a:1:{s:5:"value";s:16:"Costumer Review:";}s:15:"sArticlereviews";a:1:{s:5:"value";s:7:"Reviews";}s:12:"sArticlesave";a:1:{s:5:"value";s:5:"saved";}s:14:"sArticlescroll";a:1:{s:5:"value";s:6:"Scroll";}s:19:"sArticlesevenpoints";a:1:{s:5:"value";s:8:"7 Points";}s:16:"sArticleshipping";a:1:{s:5:"value";s:110:"<a href="{$sBasefile}?sViewport=custom&cCUSTOM=28" title="Shipping rates & policies">Shipping rates & policies";}s:27:"sArticleshippinginformation";a:1:{s:5:"value";s:33:"See our shipping rates & policies";}s:15:"sArticleshowall";a:1:{s:5:"value";s:8:"Show all";}s:28:"sArticleshowallmanufacturers";a:1:{s:5:"value";s:22:"Show all manufacturers";}s:23:"sArticlesimilararticles";a:1:{s:5:"value";s:15:"Suggested Items";}s:17:"sArticlesixpoints";a:1:{s:5:"value";s:8:"6 Points";}s:12:"sArticlesort";a:1:{s:5:"value";s:5:"Sort:";}s:15:"sArticlesummary";a:1:{s:5:"value";s:7:"Summary";}s:17:"sArticlesurcharge";a:1:{s:5:"value";s:17:"Additional charge";}s:26:"sArticlesystemrequirements";a:1:{s:5:"value";s:21:"Systemrequirement for";}s:15:"sArticletaxplus";a:1:{s:5:"value";s:8:"VAT plus";}s:16:"sArticletaxplus1";a:1:{s:5:"value";s:5:"VAT +";}s:17:"sArticletenpoints";a:1:{s:5:"value";s:9:"10 Points";}s:24:"sArticlethankyouverymuch";a:1:{s:5:"value";s:62:"Thank you very much. The recommendation was successfully sent.";}s:23:"sArticlethefieldsmarked";a:1:{s:5:"value";s:34:"Please fill in all required fields";}s:19:"sArticlethreepoints";a:1:{s:5:"value";s:8:"3 Points";}s:11:"sArticletip";a:1:{s:5:"value";s:4:"TIP!";}s:30:"sArticletipavailableasanimmedi";a:1:{s:5:"value";s:34:"Available as an immediate download";}s:26:"sArticletipmoreinformation";a:1:{s:5:"value";s:25:"Further information about";}s:29:"sArticletipproductinformation";a:1:{s:5:"value";s:19:"Product information";}s:11:"sArticletop";a:1:{s:5:"value";s:3:"TOP";}s:30:"sArticletopaveragecustomerrevi";a:1:{s:5:"value";s:17:"Customer Reviews:";}s:30:"sArticletopImmediatelyavailabl";a:1:{s:5:"value";s:8:"In Stock";}s:14:"sArticletosave";a:1:{s:5:"value";s:4:"Save";}s:25:"sArticletoseeinthepicture";a:1:{s:5:"value";s:16:"On this picture:";}s:17:"sArticletwopoints";a:1:{s:5:"value";s:8:"2 Points";}s:13:"sArticleuntil";a:1:{s:5:"value";s:5:"until";}s:17:"sArticleupdatenow";a:1:{s:5:"value";s:10:"Update now";}s:29:"sArticlewithoutagerestriction";a:1:{s:5:"value";s:23:"Without age restriction";}s:19:"sArticleworkingdays";a:1:{s:5:"value";s:10:"Workingday";}s:25:"sArticlewriteanassessment";a:1:{s:5:"value";s:15:"Create a review";}s:20:"sArticlewriteareview";a:1:{s:5:"value";s:15:"Create a review";}s:19:"sArticlewritereview";a:1:{s:5:"value";s:15:"Create a review";}s:19:"sArticleyourcomment";a:1:{s:5:"value";s:13:"Your comment:";}s:16:"sArticleyourname";a:1:{s:5:"value";s:9:"Your Name";}s:19:"sArticleyouropinion";a:1:{s:5:"value";s:13:"Your comment:";}s:18:"sArticlezeropoints";a:1:{s:5:"value";s:8:"0 Points";}s:23:"sBasketaddedtothebasket";a:1:{s:5:"value";s:32:"was added to your shopping cart!";}s:13:"sBasketamount";a:1:{s:5:"value";s:9:"Quantity:";}s:14:"sBasketArticle";a:1:{s:5:"value";s:7:"Article";}s:30:"sBasketarticlefromourcatalogue";a:1:{s:5:"value";s:29:"Add articles from our catalog";}s:22:"sBasketarticlenotfound";a:1:{s:5:"value";s:17:"Article not found";}s:20:"sBasketasanimmediate";a:1:{s:5:"value";s:34:"Available as an immediate download";}s:23:"sBasketasasmallthankyou";a:1:{s:5:"value";s:63:"As a small thank-you, you receive this article free in addition";}s:19:"sBasketavailability";a:1:{s:5:"value";s:8:"In Stock";}s:20:"sBasketavailablefrom";a:1:{s:5:"value";s:20:"Available from stock";}s:21:"sBasketbacktomainpage";a:1:{s:5:"value";s:17:"Back to Mainpage!";}s:21:"sBasketbasketdiscount";a:1:{s:5:"value";s:13:"Cart-discount";}s:30:"sBasketbetweenfollowingpremium";a:1:{s:5:"value";s:44:"Please choose between the following premiums";}s:15:"sBasketcheckout";a:1:{s:5:"value";s:8:"Checkout";}s:30:"sBasketcheckoutcustomerswithyo";a:1:{s:5:"value";s:45:"Customers Who Bought This Item Also Bought\n  ";}s:23:"sBasketcontinueshopping";a:1:{s:5:"value";s:17:"Continue shopping";}s:30:"sBasketcustomerswithyoursimila";a:1:{s:5:"value";s:48:"Customers Viewing This Page May Be Interested in";}s:30:"sBasketdeletethisitemfrombaske";a:1:{s:5:"value";s:34:"Erase this article from the basket";}s:15:"sBasketdelivery";a:1:{s:5:"value";s:13:"Shipping time";}s:22:"sBasketdeliverycountry";a:1:{s:5:"value";s:16:"Shipping country";}s:24:"sBasketdesignatedarticle";a:1:{s:5:"value";s:50:"Favorites - selected articles for a later purchase";}s:15:"sBasketdispatch";a:1:{s:5:"value";s:16:"Mode of shipment";}s:23:"sBasketerasefromnotepad";a:1:{s:5:"value";s:37:"Erase this article from the favorites";}s:25:"sBasketforwardingexpenses";a:1:{s:5:"value";s:25:"Shipping rates & policies";}s:11:"sBasketfree";a:1:{s:5:"value";s:5:"FREE!";}s:12:"sBasketfree1";a:1:{s:5:"value";s:4:"FREE";}s:11:"sBasketfrom";a:1:{s:5:"value";s:4:"from";}s:18:"sBasketinthebasket";a:1:{s:5:"value";s:20:"add to shopping cart";}s:20:"sBasketintothebasket";a:1:{s:5:"value";s:20:"Add to shopping cart";}s:28:"sBasketItautomaticallystores";a:1:{s:5:"value";s:126:"automatically stores your personal favorite-list.\nYou can comfortably retrieve your registered articles in a subsequent visit.";}s:26:"sBasketjustthedesireditems";a:1:{s:5:"value";s:56:"Put simply the desired articles on the favorite-list and";}s:23:"sBasketlastinyourbasket";a:1:{s:5:"value";s:32:"Last article added in your cart:";}s:24:"sBasketminimumordervalue";a:1:{s:5:"value";s:37:"Attention. The minimum order value of";}s:13:"sBasketmodify";a:1:{s:5:"value";s:6:"Modify";}s:23:"sBasketmoreinformations";a:1:{s:5:"value";s:16:"More information";}s:27:"sBasketnoitemsonyournotepad";a:1:{s:5:"value";s:45:"There are no articles on your favorites-list.";}s:25:"sBasketnopictureavailable";a:1:{s:5:"value";s:20:"No picture available";}s:14:"sBasketnotepad";a:1:{s:5:"value";s:9:"Favorites";}s:20:"sBasketnotreachedyet";a:1:{s:5:"value";s:19:"is not reached yet!";}s:13:"sBasketnumber";a:1:{s:5:"value";s:8:"Quantity";}s:18:"sBasketordernumber";a:1:{s:5:"value";s:9:"Order No.";}s:14:"sBasketpayment";a:1:{s:5:"value";s:17:"Method of Payment";}s:19:"sBasketpleasechoose";a:1:{s:5:"value";s:16:"Please choose...";}s:23:"sBasketrecalculateprice";a:1:{s:5:"value";s:31:"Recalculate price - update cart";}s:26:"sBasketsaveyourpersonalfav";a:1:{s:5:"value";s:60:"Save your personal favorites - until you visit us next time.";}s:17:"sBasketshowbasket";a:1:{s:5:"value";s:18:"Show shopping cart";}s:18:"sBasketstep1basket";a:1:{s:5:"value";s:21:"Step1 - Shopping Cart";}s:15:"sBasketsubtotal";a:1:{s:5:"value";s:9:"Subtotal:";}s:10:"sBasketsum";a:1:{s:5:"value";s:5:"Total";}s:17:"sBaskettocheckout";a:1:{s:5:"value";s:9:"Checkout!";}s:15:"sBaskettotalsum";a:1:{s:5:"value";s:5:"Total";}s:16:"sBasketunitprice";a:1:{s:5:"value";s:10:"Unit price";}s:15:"sBasketweekdays";a:1:{s:5:"value";s:8:"Workdays";}s:17:"sBasketyourbasket";a:1:{s:5:"value";s:18:"Your shopping cart";}s:24:"sBasketyourbasketisempty";a:1:{s:5:"value";s:43:"There are no articles in your shopping cart";}s:21:"sCategorymanufacturer";a:1:{s:5:"value";s:12:"Manufacturer";}s:18:"sCategorynopicture";a:1:{s:5:"value";s:20:"No picture available";}s:26:"sCategoryothermanufacturer";a:1:{s:5:"value";s:19:"Other manufacturers";}s:16:"sCategoryshowall";a:1:{s:5:"value";s:8:"Show all";}s:18:"sCategorytopseller";a:1:{s:5:"value";s:9:"Topseller";}s:18:"sContentattachment";a:1:{s:5:"value";s:11:"Attachment:";}s:12:"sContentback";a:1:{s:5:"value";s:4:"Back";}s:14:"sContentbrowse";a:1:{s:5:"value";s:7:"Browse:";}s:21:"sContentbrowseforward";a:1:{s:5:"value";s:14:"Browse forward";}s:26:"sContentcurrentlynoentries";a:1:{s:5:"value";s:30:"Currently no entries available";}s:16:"sContentdownload";a:1:{s:5:"value";s:8:"Download";}s:21:"sContententrynotfound";a:1:{s:5:"value";s:14:"No entry found";}s:21:"sContentgobackonepage";a:1:{s:5:"value";s:16:"Browse backward ";}s:12:"sContentmore";a:1:{s:5:"value";s:6:"[more]";}s:24:"sContentmoreinformations";a:1:{s:5:"value";s:17:"More information:";}s:21:"sContentonthispicture";a:1:{s:5:"value";s:16:"On this picture:";}s:20:"sCustomdirectcontact";a:1:{s:5:"value";s:14:"Direct contact";}s:19:"sCustomsitenotfound";a:1:{s:5:"value";s:14:"Page not found";}s:19:"sErrorBillingAdress";a:1:{s:5:"value";s:40:"Please fill out all fields marked in red";}s:14:"sErrorcheckout";a:1:{s:5:"value";s:8:"Checkout";}s:21:"sErrorCookiesDisabled";a:1:{s:5:"value";s:66:"To use this feature, you must have cookies enabled in your browser";}s:11:"sErrorEmail";a:1:{s:5:"value";s:34:"Please enter a valid email address";}s:19:"sErrorEmailForgiven";a:1:{s:5:"value";s:40:"This email address is already registered";}s:19:"sErrorEmailNotFound";a:1:{s:5:"value";s:32:"This email address was not found";}s:11:"sErrorerror";a:1:{s:5:"value";s:21:"An error has occurred";}s:23:"sErrorForgotMailUnknown";a:1:{s:5:"value";s:28:"This mail address is unknown";}s:10:"sErrorhome";a:1:{s:5:"value";s:4:"Home";}s:11:"sErrorLogin";a:1:{s:5:"value";s:50:"Your access data could not be assigned to any user";}s:23:"sErrorMerchantNotActive";a:1:{s:5:"value";s:73:"You are not registered as a reseller or your account has not approved yet";}s:29:"sErrormoreinterestingarticles";a:1:{s:5:"value";s:17:"You may also like";}s:22:"sErrororderwascanceled";a:1:{s:5:"value";s:22:"The order was canceled";}s:14:"sErrorPassword";a:1:{s:5:"value";s:57:"Please choose a password consisting at least 6 characters";}s:21:"sErrorShippingAddress";a:1:{s:5:"value";s:40:"Please fill out all fields marked in red";}s:27:"sErrorthisarticleisnolonger";a:1:{s:5:"value";s:34:"The product has been discontinued!";}s:12:"sErrorUnknow";a:1:{s:5:"value";s:29:"An unknown error has occurred";}s:16:"sErrorValidEmail";a:1:{s:5:"value";s:34:"Please enter a valid email address";}s:13:"sIndexaccount";a:1:{s:5:"value";s:10:"My Account";}s:16:"sIndexactivation";a:1:{s:5:"value";s:284:"3. Activation: As soon as both satisfactory forms are given to us and provided that your signatures match, we switch you for plays from 18 freely. Afterwards we immediately send you a confirmation email. Then you can quite simply order the USK 18 title comfortably about the web shop.";}s:25:"sIndexallpricesexcludevat";a:1:{s:5:"value";s:28:"* All prices exclude VAT and";}s:25:"sIndexandpossibledelivery";a:1:{s:5:"value";s:50:"and possibly shipping fees unless otherwise stated";}s:12:"sIndexappear";a:1:{s:5:"value";s:9:"Released:";}s:13:"sIndexarticle";a:1:{s:5:"value";s:10:"article(s)";}s:19:"sIndexarticlesfound";a:1:{s:5:"value";s:18:" article(s) found!";}s:24:"sIndexavailabledownloads";a:1:{s:5:"value";s:20:"Available downloads:";}s:16:"sIndexbacktohome";a:1:{s:5:"value";s:12:"back to home";}s:12:"sIndexbasket";a:1:{s:5:"value";s:16:"My shopping cart";}s:25:"sIndexcertifiedonlineshop";a:1:{s:5:"value";s:113:"Trusted Shops certified online shop with money-back guarantee. Click on the seal in order to verify the validity.";}s:26:"sIndexchangebillingaddress";a:1:{s:5:"value";s:22:"Change billing address";}s:27:"sIndexchangedeliveryaddress";a:1:{s:5:"value";s:23:"Change delivery address";}s:19:"sIndexchangepayment";a:1:{s:5:"value";s:24:"Change method of payment";}s:19:"sIndexclientaccount";a:1:{s:5:"value";s:16:"Customer account";}s:26:"sIndexcompareupto5articles";a:1:{s:5:"value";s:42:"You can compare up to 5 items in one step!";}s:15:"sIndexcopyright";a:1:{s:5:"value";s:51:"Copyright © 2008 shopware.ag - All rights reserved.";}s:11:"sIndexcover";a:1:{s:5:"value";s:6:"Cover:";}s:14:"sIndexcurrency";a:1:{s:5:"value";s:9:"Currency:";}s:14:"sIndexdownload";a:1:{s:5:"value";s:8:"Download";}s:13:"sIndexenglish";a:1:{s:5:"value";s:7:"English";}s:11:"sIndexextra";a:1:{s:5:"value";s:7:"Extras:";}s:28:"sIndexforreasonofinformation";a:1:{s:5:"value";s:477:"For reasons of information we display in our online shop also games which own no gift suitable for young people. However, there is a way for customers, who have already completed the eighteenth year,  to purchase these games. Now you can order with us also quite simply USK 18 games above the postal dispatch way. To fulfil the requirements of the protection of children and young people-sedate you must be personalised in addition simply by Postident. The way is quite simply:";}s:12:"sIndexfrench";a:1:{s:5:"value";s:6:"French";}s:10:"sIndexfrom";a:1:{s:5:"value";s:4:"from";}s:12:"sIndexgerman";a:1:{s:5:"value";s:6:"German";}s:11:"sIndexhello";a:1:{s:5:"value";s:5:"Hello";}s:10:"sIndexhome";a:1:{s:5:"value";s:4:"Home";}s:20:"sIndexhowcaniacquire";a:1:{s:5:"value";s:68:"How can i acquire the games which are restricted only from 18 years?";}s:14:"sIndexlanguage";a:1:{s:5:"value";s:9:"Language:";}s:12:"sIndexlogout";a:1:{s:5:"value";s:6:"Logout";}s:14:"sIndexmybasket";a:1:{s:5:"value";s:12:"Show my cart";}s:24:"sIndexmyinstantdownloads";a:1:{s:5:"value";s:20:"My instant downloads";}s:14:"sIndexmyorders";a:1:{s:5:"value";s:9:"My orders";}s:22:"sIndexnoagerestriction";a:1:{s:5:"value";s:23:"Without age restriction";}s:13:"sIndexnotepad";a:1:{s:5:"value";s:9:"Favorites";}s:18:"sIndexonthepicture";a:1:{s:5:"value";s:16:"On this picture:";}s:17:"sIndexordernumber";a:1:{s:5:"value";s:10:"Order no.:";}s:18:"sIndexourcommentto";a:1:{s:5:"value";s:13:"Our review on";}s:14:"sIndexoverview";a:1:{s:5:"value";s:8:"Overview";}s:16:"sIndexpagenumber";a:1:{s:5:"value";s:11:"Pagenumber:";}s:26:"sIndexpossiblydeliveryfees";a:1:{s:5:"value";s:50:"and possibly shipping fees unless otherwise stated";}s:15:"sIndexpostident";a:1:{s:5:"value";s:171:"2. POSTIDENT: The German post provides a POSTIDENT form in the confirmation of your majority. Please, sign this also. Then the German post sends both signed documents to .";}s:19:"sIndexpricesinclvat";a:1:{s:5:"value";s:27:"* All prices incl. VAT plus";}s:14:"sIndexprinting";a:1:{s:5:"value";s:6:"Print:";}s:25:"sIndexproductinformations";a:1:{s:5:"value";s:19:"Product information";}s:18:"sIndexrealizedwith";a:1:{s:5:"value";s:13:"realised with";}s:30:"sIndexrealizedwiththeshopsyste";a:1:{s:5:"value";s:57:"realized by shopware ag an the webshop-software Shopware ";}s:14:"sIndexreleased";a:1:{s:5:"value";s:19:"unrated (universal)";}s:25:"sIndexreleasedfrom12years";a:1:{s:5:"value";s:20:"Restricted 12 years+";}s:25:"sIndexreleasedfrom16years";a:1:{s:5:"value";s:20:"Restricted 16 years+";}s:25:"sIndexreleasedfrom18years";a:1:{s:5:"value";s:20:"Restricted 18 years+";}s:24:"sIndexreleasedfrom6years";a:1:{s:5:"value";s:19:"Restricted 6 years+";}s:12:"sIndexsearch";a:1:{s:5:"value";s:0:"";}s:14:"sIndexshipping";a:1:{s:5:"value";s:14:"Shipping rates";}s:14:"sIndexshopware";a:1:{s:5:"value";s:8:"Shopware";}s:17:"sIndexshownotepad";a:1:{s:5:"value";s:14:"Show favorites";}s:21:"sIndexsimilararticles";a:1:{s:5:"value";s:15:"Suggested Items";}s:10:"sIndexsite";a:1:{s:5:"value";s:4:"Page";}s:22:"sIndexsuitablearticles";a:1:{s:5:"value";s:16:"Suggested Items:";}s:27:"sIndexsystemrequirementsfor";a:1:{s:5:"value";s:22:"System requirement for";}s:8:"sIndexto";a:1:{s:5:"value";s:2:"To";}s:23:"sIndextrustedshopslabel";a:1:{s:5:"value";s:61:"Trusted shops stamp of quality - request validity check here!";}s:19:"sIndexviewmyaccount";a:1:{s:5:"value";s:16:"Visit my account";}s:19:"sIndexwelcometoyour";a:1:{s:5:"value";s:28:"and welcome to your personal";}s:10:"sIndexwere";a:1:{s:5:"value";s:4:"were";}s:16:"sIndexyouarehere";a:1:{s:5:"value";s:13:"You are here:";}s:19:"sIndexyouloadthepdf";a:1:{s:5:"value";s:222:"1. Load the PDF registration form in your customer area and print it out. Please, present this form together with your identity card or passport in a branch of the German post. Mark the appropriate field and sign the form.";}s:26:"sInfoEmailAlreadyRegiested";a:1:{s:5:"value";s:34:"You already receive our newsletter";}s:26:"sLoginalreadyhaveanaccount";a:1:{s:5:"value";s:25:"I am a returning customer";}s:15:"sLoginareyounew";a:1:{s:5:"value";s:27:"New customer? Start here at";}s:10:"sLoginback";a:1:{s:5:"value";s:4:"Back";}s:18:"sLogindealeraccess";a:1:{s:5:"value";s:16:"Reseller account";}s:11:"sLoginerror";a:1:{s:5:"value";s:22:"An error has occurred!";}s:24:"sLoginloginwithyouremail";a:1:{s:5:"value";s:50:"Please login using your eMail address and password";}s:18:"sLoginlostpassword";a:1:{s:5:"value";s:21:"Forgot your password?";}s:28:"sLoginlostpasswordhereyoucan";a:1:{s:5:"value";s:57:"Forgot your password? Here you can request a new password";}s:17:"sLoginnewcustomer";a:1:{s:5:"value";s:12:"New customer";}s:28:"sLoginnewpasswordhasbeensent";a:1:{s:5:"value";s:38:"Your new password has been sent to you";}s:15:"sLoginnoproblem";a:1:{s:5:"value";s:91:"No problem, ordering from us is easy and secure. The registration takes only a few moments.";}s:14:"sLoginpassword";a:1:{s:5:"value";s:14:"Your password:";}s:17:"sLoginregisternow";a:1:{s:5:"value";s:12:"Register now";}s:16:"sLoginstep1login";a:1:{s:5:"value";s:26:"Step1 - Login/Registration";}s:27:"sLoginwewillsendyouanewpass";a:1:{s:5:"value";s:94:"We will send you a new, randomly generated password. This can be changed in the customer area.";}s:21:"sLoginyouremailadress";a:1:{s:5:"value";s:19:"Your email address:";}s:27:"sOrderprocessacceptourterms";a:1:{s:5:"value";s:46:"Please accept our general terms and conditions";}s:19:"sOrderprocessamount";a:1:{s:5:"value";s:8:"Quantity";}s:20:"sOrderprocessarticle";a:1:{s:5:"value";s:7:"Article";}s:26:"sOrderprocessbillingadress";a:1:{s:5:"value";s:72:"You can change billing address, shipping address and payment method now.";}s:27:"sOrderprocessbillingadress1";a:1:{s:5:"value";s:15:"Billing address";}s:19:"sOrderprocesschange";a:1:{s:5:"value";s:6:"Change";}s:25:"sOrderprocesschangebasket";a:1:{s:5:"value";s:20:"Change shopping cart";}s:30:"sOrderprocesschangeyourpayment";a:1:{s:5:"value";s:122:"Please change your payment method. The purchase of instant downloads is currently not possible with your selected payment!";}s:22:"sOrderprocessclickhere";a:1:{s:5:"value";s:44:"Trusted Shops stamp of quality - click here.";}s:20:"sOrderprocesscomment";a:1:{s:5:"value";s:11:"Annotation:";}s:20:"sOrderprocesscompany";a:1:{s:5:"value";s:7:"Company";}s:28:"sOrderprocessdeliveryaddress";a:1:{s:5:"value";s:16:"Shipping address";}s:21:"sOrderprocessdispatch";a:1:{s:5:"value";s:16:"Shipping method:";}s:25:"sOrderprocessdoesnotreach";a:1:{s:5:"value";s:16:"not reached yet!";}s:28:"sOrderprocessenteradditional";a:1:{s:5:"value";s:57:"Please, give here additional information about your order";}s:30:"sOrderprocessforwardingexpense";a:1:{s:5:"value";s:15:"Shipping costs:";}s:25:"sOrderprocessforyourorder";a:1:{s:5:"value";s:28:"Thank you for your order at ";}s:17:"sOrderprocessfree";a:1:{s:5:"value";s:4:"FREE";}s:26:"sOrderprocessimportantinfo";a:1:{s:5:"value";s:45:"Important information to the shipping country";}s:30:"sOrderprocessinformationsabout";a:1:{s:5:"value";s:30:"Informations about your order:";}s:27:"sOrderprocessmakethepayment";a:1:{s:5:"value";s:15:"Please pay now:";}s:30:"sOrderprocessminimumordervalue";a:1:{s:5:"value";s:46:"Attention. You have the minimum order value of";}s:15:"sOrderprocessmr";a:1:{s:5:"value";s:2:"Mr";}s:15:"sOrderprocessms";a:1:{s:5:"value";s:2:"Ms";}s:21:"sOrderprocessnettotal";a:1:{s:5:"value";s:10:"Net total:";}s:24:"sOrderprocessordernumber";a:1:{s:5:"value";s:13:"Order number:";}s:30:"sOrderprocessperorderonevouche";a:1:{s:5:"value";s:41:"Per order max. one voucher can be cashed.";}s:24:"sOrderprocesspleasecheck";a:1:{s:5:"value";s:50:"Please, check your order again, before sending it.";}s:18:"sOrderprocessprice";a:1:{s:5:"value";s:5:"Price";}s:18:"sOrderprocessprint";a:1:{s:5:"value";s:5:"Print";}s:27:"sOrderprocessprintorderconf";a:1:{s:5:"value";s:33:"Print out order confirmation now!";}s:29:"sOrderprocessrecommendtoprint";a:1:{s:5:"value";s:55:"We recommend to print out the order confirmation below.";}s:23:"sOrderprocessrevocation";a:1:{s:5:"value";s:18:"Right of withdrawl";}s:26:"sOrderprocesssameappliesto";a:1:{s:5:"value";s:42:"The same applies to the selected articles.";}s:28:"sOrderprocessselectedpayment";a:1:{s:5:"value";s:22:"Choosen payment method";}s:30:"sOrderprocessspecifythetransfe";a:1:{s:5:"value";s:60:"Please, give by the referral the following intended purpose:";}s:25:"sOrderprocesstotalinclvat";a:1:{s:5:"value";s:16:"Total incl. VAT:";}s:23:"sOrderprocesstotalprice";a:1:{s:5:"value";s:5:"Total";}s:29:"sOrderprocesstransactionumber";a:1:{s:5:"value";s:19:"Transaction number:";}s:30:"sOrderprocesstrustedshopmember";a:1:{s:5:"value";s:155:"As a member of Trusted Shops, we offer a\n     additional money-back guarantee. We take all\n     Cost of this warranty, you only need to be\n     registered.";}s:26:"sOrderprocessvouchernumber";a:1:{s:5:"value";s:15:"Voucher number:";}s:27:"sOrderprocesswehaveprovided";a:1:{s:5:"value";s:48:"We have sent you an order confirmation by eMail.";}s:28:"sOrderprocessyourvouchercode";a:1:{s:5:"value";s:62:"Please, enter your voucher code here and click on the "arrow".";}s:21:"sPaymentaccountnumber";a:1:{s:5:"value";s:16:"Account number*:";}s:22:"sPaymentbankcodenumber";a:1:{s:5:"value";s:17:"Bank code number:";}s:28:"sPaymentchooseyourcreditcard";a:1:{s:5:"value";s:26:"Choose your credit card *:";}s:24:"sPaymentcreditcardnumber";a:1:{s:5:"value";s:26:"Your credit card number *:";}s:25:"sPaymentcurrentlyselected";a:1:{s:5:"value";s:18:"Currently selected";}s:26:"sPaymentcurrentlyselected1";a:1:{s:5:"value";s:18:"Currently Selected";}s:11:"sPaymentEsd";a:1:{s:5:"value";s:14:"online banking";}s:23:"sPaymentmarkedfieldsare";a:1:{s:5:"value";s:43:"Please fill in all required address fields.";}s:13:"sPaymentmonth";a:1:{s:5:"value";s:5:"Month";}s:24:"sPaymentnameofcardholder";a:1:{s:5:"value";s:20:"Name of cardholder*:";}s:16:"sPaymentshipping";a:1:{s:5:"value";s:25:"Shipping rates & policies";}s:18:"sPaymentvaliduntil";a:1:{s:5:"value";s:14:"Valid until *:";}s:12:"sPaymentyear";a:1:{s:5:"value";s:4:"Year";}s:16:"sPaymentyourbank";a:1:{s:5:"value";s:11:"Your Bank*:";}s:22:"sPaymentyourcreditcard";a:1:{s:5:"value";s:15:"Your creditcard";}s:19:"sRegisteraccessdata";a:1:{s:5:"value";s:10:"Your Login";}s:25:"sRegisterafterregistering";a:1:{s:5:"value";s:79:"Once your account is approved, you will see your reseller prices in this shop.\n";}s:30:"sRegisteralreadyhaveatraderacc";a:1:{s:5:"value";s:36:"You have already a reseller account?";}s:13:"sRegisterback";a:1:{s:5:"value";s:4:"Back";}s:18:"sRegisterbirthdate";a:1:{s:5:"value";s:10:"Birthdate:";}s:19:"sRegistercharacters";a:1:{s:5:"value";s:11:"Characters.";}s:19:"sRegistercityandzip";a:1:{s:5:"value";s:22:"Postal Code and City*:";}s:25:"sRegisterclickheretologin";a:1:{s:5:"value";s:20:"Click here to log in";}s:16:"sRegistercompany";a:1:{s:5:"value";s:8:"Company:";}s:22:"sRegisterconsiderupper";a:1:{s:5:"value";s:31:"Consider upper and lower case. ";}s:16:"sRegistercountry";a:1:{s:5:"value";s:9:"Country*:";}s:19:"sRegisterdepartment";a:1:{s:5:"value";s:11:"Department:";}s:29:"sRegisterenterdeliveryaddress";a:1:{s:5:"value";s:29:"Enter a delivery address here";}s:22:"sRegistererroroccurred";a:1:{s:5:"value";s:22:"An error has occurred!";}s:12:"sRegisterfax";a:1:{s:5:"value";s:4:"Fax:";}s:21:"sRegisterfieldsmarked";a:1:{s:5:"value";s:18:"* required fields.";}s:18:"sRegisterfirstname";a:1:{s:5:"value";s:13:"First name *:";}s:22:"sRegisterforavatexempt";a:1:{s:5:"value";s:89:"Enter a VAT number to remove tax for orders being delivered to a country outside the EU. ";}s:23:"sRegisterfreetextfields";a:1:{s:5:"value";s:44:"Additional Info: (for example: mobile phone)";}s:20:"sRegisterinthefuture";a:1:{s:5:"value";s:59:"Please SET up your account so that you can see your orders.";}s:17:"sRegisterlastname";a:1:{s:5:"value";s:11:"Last name*:";}s:11:"sRegistermr";a:1:{s:5:"value";s:3:"Mr.";}s:11:"sRegisterms";a:1:{s:5:"value";s:3:"Ms.";}s:13:"sRegisternext";a:1:{s:5:"value";s:4:"Next";}s:26:"sRegisternocustomeraccount";a:1:{s:5:"value";s:30:"Do not open a customer account";}s:29:"sRegisteronthisfollowingpages";a:1:{s:5:"value";s:0:"";}s:14:"sRegisterphone";a:1:{s:5:"value";s:7:"Phone*:";}s:21:"sRegisterpleasechoose";a:1:{s:5:"value";s:14:"Please choose:";}s:21:"sRegisterpleaseselect";a:1:{s:5:"value";s:17:"Please choose...\n";}s:27:"sRegisterrepeatyourpassword";a:1:{s:5:"value";s:22:"Repeat your password*:";}s:19:"sRegisterrevocation";a:1:{s:5:"value";s:18:"Right of withdrawl";}s:13:"sRegistersave";a:1:{s:5:"value";s:4:"Save";}s:22:"sRegisterselectpayment";a:1:{s:5:"value";s:43:"Please choose your preferred payment method";}s:29:"sRegistersendusyourtradeproof";a:1:{s:5:"value";s:28:"Fax your VAT number to us at";}s:30:"sRegistersendusyourtradeproofb";a:1:{s:5:"value";s:151:"Send your VAT number by fax to +49 2555 99 75 0 99.\nIf you are already a registered re-seller, you can skip this part. You don´t have to send it again.";}s:25:"sRegisterseperatedelivery";a:1:{s:5:"value";s:50:"I would like to enter a different delivery address";}s:30:"sRegistershippingaddressdiffer";a:1:{s:5:"value";s:56:"Your shipping address differs from your billing address.";}s:24:"sRegisterstreetandnumber";a:1:{s:5:"value";s:16:"Street and No.*:";}s:28:"sRegistersubscribenewsletter";a:1:{s:5:"value";s:26:"Sign up for our newsletter";}s:14:"sRegistertitle";a:1:{s:5:"value";s:7:"Title*:";}s:27:"sRegistertraderregistration";a:1:{s:5:"value";s:21:"Reseller Registration";}s:14:"sRegistervatid";a:1:{s:5:"value";s:11:"VAT number:";}s:16:"sRegisterwecheck";a:1:{s:5:"value";s:49:"After verification your account will be approved.";}s:27:"sRegisterwecheckyouastrader";a:1:{s:5:"value";s:212:"After verification your account will be approved. After clearing you get informations per eMail.\nFrom now on, you´ll see your special reseller prices directly, displayed on the product-detail- and overview-pages.";}s:24:"sRegisteryouraccountdata";a:1:{s:5:"value";s:17:"Your billing data";}s:18:"sRegisteryouremail";a:1:{s:5:"value";s:20:"Your eMail-address*:";}s:21:"sRegisteryourpassword";a:1:{s:5:"value";s:15:"Your password*:";}s:27:"sRegisteryourpasswordatlast";a:1:{s:5:"value";s:33:"Your password needs a minimum of ";}s:19:"sSearchafterfilters";a:1:{s:5:"value";s:9:"by filter";}s:20:"sSearchallcategories";a:1:{s:5:"value";s:19:"Show all categories";}s:17:"sSearchallfilters";a:1:{s:5:"value";s:11:"All filters";}s:22:"sSearchallmanufacturer";a:1:{s:5:"value";s:17:"All Manufacturers";}s:16:"sSearchallprices";a:1:{s:5:"value";s:10:"All Prices";}s:20:"sSearcharticlesfound";a:1:{s:5:"value";s:18:" article(s) found!";}s:22:"sSearcharticlesperpage";a:1:{s:5:"value";s:18:"Articles per page:";}s:13:"sSearchbrowse";a:1:{s:5:"value";s:7:"Browse:";}s:21:"sSearchbymanufacturer";a:1:{s:5:"value";s:15:"by manufacturer";}s:14:"sSearchbyprice";a:1:{s:5:"value";s:8:"by price";}s:14:"sSearchelected";a:1:{s:5:"value";s:8:"Choosen:";}s:19:"sSearchhighestprice";a:1:{s:5:"value";s:13:"Highest price";}s:16:"sSearchitemtitle";a:1:{s:5:"value";s:19:"Article description";}s:18:"sSearchlowestprice";a:1:{s:5:"value";s:12:"Lowest price";}s:15:"sSearchnextpage";a:1:{s:5:"value";s:9:"Next page";}s:22:"sSearchnoarticlesfound";a:1:{s:5:"value";s:42:"Your search did not match to any articles!";}s:18:"sSearchonepageback";a:1:{s:5:"value";s:13:"One page back";}s:25:"sSearchothermanufacturers";a:1:{s:5:"value";s:20:"Other manufacturers:";}s:17:"sSearchpopularity";a:1:{s:5:"value";s:11:"Bestselling";}s:18:"sSearchreleasedate";a:1:{s:5:"value";s:12:"Release date";}s:16:"sSearchrelevance";a:1:{s:5:"value";s:9:"Relevance";}s:23:"sSearchsearchcategories";a:1:{s:5:"value";s:20:"Search by categories";}s:19:"sSearchsearchresult";a:1:{s:5:"value";s:16:"Search result(s)";}s:25:"sSearchsearchtermtooshort";a:1:{s:5:"value";s:37:"The entered search term is too short.";}s:14:"sSearchshowall";a:1:{s:5:"value";s:8:"Show all";}s:11:"sSearchsort";a:1:{s:5:"value";s:5:"Sort:";}s:9:"sSearchto";a:1:{s:5:"value";s:2:"to";}s:29:"sSearchunfortunatelytherewere";a:1:{s:5:"value";s:38:"unfortunately no entries were found to";}s:11:"sSearchwere";a:1:{s:5:"value";s:4:"were";}s:24:"sSupportallmanufacturers";a:1:{s:5:"value";s:22:"List all manufacturers";}s:22:"sSupportarticleperpage";a:1:{s:5:"value";s:18:"Articles per page:";}s:12:"sSupportback";a:1:{s:5:"value";s:4:"Back";}s:14:"sSupportbrowse";a:1:{s:5:"value";s:7:"Browse:";}s:23:"sSupportenterthenumbers";a:1:{s:5:"value";s:52:"Please enter the numbers into the following text box";}s:21:"sSupportentrynotfound";a:1:{s:5:"value";s:15:"No Entry found.";}s:24:"sSupportfieldsmarketwith";a:1:{s:5:"value";s:43:"Please fill in all required address fields.";}s:20:"sSupporthighestprice";a:1:{s:5:"value";s:13:"Highest price";}s:17:"sSupportitemtitle";a:1:{s:5:"value";s:19:"Article description";}s:19:"sSupportlowestprice";a:1:{s:5:"value";s:12:"Lowest price";}s:16:"sSupportnextpage";a:1:{s:5:"value";s:16:"One page forward";}s:19:"sSupportonepageback";a:1:{s:5:"value";s:13:"One page back";}s:18:"sSupportpopularity";a:1:{s:5:"value";s:11:"Bestselling";}s:19:"sSupportreleasedate";a:1:{s:5:"value";s:12:"Release date";}s:12:"sSupportsend";a:1:{s:5:"value";s:4:"Send";}s:12:"sSupportsort";a:1:{s:5:"value";s:8:"sort by:";}s:21:"sVoucherAlreadyCashed";a:1:{s:5:"value";s:53:"This voucher was already cashed with a previous order";}s:23:"sVoucherBoundToSupplier";a:1:{s:5:"value";s:56:"This voucher is valid only for products from {sSupplier}";}s:21:"sVoucherMinimumCharge";a:1:{s:5:"value";s:64:"The minimum turnover for this voucher amounts {sMinimumCharge} ?";}s:16:"sVoucherNotFound";a:1:{s:5:"value";s:51:"Voucher could not be found or is not valid any more";}s:23:"sVoucherOnlyOnePerOrder";a:1:{s:5:"value";s:40:"Per order only one voucher can be cashed";}s:26:"sVoucherWrongCustomergroup";a:1:{s:5:"value";s:52:"This coupon is not available for your customer group";}s:25:"sArticleinformationsabout";a:1:{s:5:"value";s:47:"Information about restricted 18 years+-articles";}s:27:"sArticlethevoucherautomatic";a:1:{s:5:"value";s:209:"* The voucher will be delivered automatically to you by eMail after registration and the first order of your friend. You have to be registered with the choosen email address in the shop to receive the voucher.";}s:18:"sBasketrecalculate";a:1:{s:5:"value";s:11:"Recalculate";}s:11:"sLoginlogin";a:1:{s:5:"value";s:5:"Login";}s:25:"sOrderprocesssendordernow";a:1:{s:5:"value";s:14:"Send order now";}s:28:"sOrderprocessforthemoneyback";a:1:{s:5:"value";s:41:"Registration for the money-back guarantee";}s:17:"sSearchcategories";a:1:{s:5:"value";s:11:"Categories:";}s:19:"sSearchmanufacturer";a:1:{s:5:"value";s:13:"Manufacturer:";}s:21:"sSearchshowallresults";a:1:{s:5:"value";s:16:"Show all results";}s:21:"sSearchnosearchengine";a:1:{s:5:"value";s:24:"No search engine support";}s:27:"sSupportfilloutallredfields";a:1:{s:5:"value";s:38:"Please fill out all red marked fields.";}s:12:"sArticlesend";a:1:{s:5:"value";s:4:"Send";}s:14:"sContact_right";a:1:{s:5:"value";s:72:"<strong>Demoshop<br />\n</strong><br />\nAdd your contact information here";}s:12:"sBankContact";a:1:{s:5:"value";s:71:"<strong>\nOur bank:\n</strong>\nVolksbank Musterstadt\nBIN:\nAccount number:";}s:11:"sArticleof1";a:1:{s:5:"value";s:2:"of";}s:25:"sBasketshippingdifference";a:1:{s:5:"value";s:49:"Order #1 #2 to get the whole order shipping free!";}s:19:"sRegister_advantage";a:1:{s:5:"value";s:218:"<h2>My advantages</h2>\n<ul>\n<li>faster shopping</li>\n<li>Save your user data and settings</li>\n<li>Have a look at your orders including shipping information</li>\n<li>Administrate your newsletter subscription</li>\n</ul>";}s:20:"sArticlePricePerUnit";a:1:{s:5:"value";s:14:"Price per unit";}s:18:"sArticleLastViewed";a:1:{s:5:"value";s:11:"Last viewed";}s:16:"sBasketLessStock";a:1:{s:5:"value";s:57:"Unfortunately there are not enough articles left in stock";}s:20:"sBasketLessStockRest";a:1:{s:5:"value";s:76:"Unfortunately there are not enough articles left in stock (x of y selctable)";}s:24:"sBasketPremiumDifference";a:1:{s:5:"value";s:36:"You almost reached this premium! Add";}s:19:"sAGBTextPaymentform";a:1:{s:5:"value";s:42:"I read the general terms and conditions...";}s:14:"sBasketInquiry";a:1:{s:5:"value";s:19:"Solicit a quotation";}s:21:"sArticleCompareDetail";a:1:{s:5:"value";s:15:"Compare article";}}'
                    WHERE objectdata = 'a:546:{s:15:"sPaymentESDInfo";a:1:{s:5:"value";s:69:"Purchase of direct downloads is only possible by debit or credit card";}s:8:"sAGBText";a:1:{s:5:"value";s:181:"I have read the <a href="{$sBasefile}?sViewport=custom&cCUSTOM=4" title="Terms"><span style="text-decoration:underline;">Terms</span></a> of your shop and agree with their coverage.";}s:10:"sOrderInfo";a:1:{s:5:"value";s:112:"(Optionaler Freitext)If you pay debit or with your creditcard your bank account will be charged after five days.";}s:15:"sRegister_right";a:1:{s:5:"value";s:183:"<p>\nInsert your right of withdrawl here.\n<br /><br />\n<a href="{$sBasefile}?sViewport=custom&cCUSTOM=8" title="Right of Withdrawl">more informations to your right of withdrawl</a></p>";}s:28:"sNewsletterOptionUnsubscribe";a:1:{s:5:"value";s:26:"unsubscribe the newsletter";}s:26:"sNewsletterOptionSubscribe";a:1:{s:5:"value";s:24:"subscribe the newsletter";}s:15:"sNewsletterInfo";a:1:{s:5:"value";s:151:"Subsribe and get our newsletter.<br />\nOf course you can cancel this newsletter any time. Use the hyperlink in your eMail or visit this website again. ";}s:17:"sNewsletterButton";a:1:{s:5:"value";s:4:"Save";}s:20:"sNewsletterLabelMail";a:1:{s:5:"value";s:19:"Your eMail-address:";}s:22:"sNewsletterLabelSelect";a:1:{s:5:"value";s:10:"I want to:";}s:17:"sInfoEmailDeleted";a:1:{s:5:"value";s:32:"Your eMail-address were deleted.";}s:19:"sInfoEmailRegiested";a:1:{s:5:"value";s:35:"Thanks. We added your eMail-address";}s:16:"sErrorEnterEmail";a:1:{s:5:"value";s:31:"Please specify an email address";}s:16:"sErrorForgotMail";a:1:{s:5:"value";s:31:"Please enter your email address";}s:10:"sDelivery1";a:1:{s:5:"value";s:47:"Ready for shipment,<br/>\nShipping time 1-3 days";}s:17:"sErrorLoginActive";a:1:{s:5:"value";s:84:"Your account has been disabled, to clarify please get in contact with us personally!";}s:27:"sAccountACommentisdeposited";a:1:{s:5:"value";s:20:"A Comment is leaved!";}s:15:"sAccountArticle";a:1:{s:5:"value";s:7:"Article";}s:22:"sAccountBillingAddress";a:1:{s:5:"value";s:15:"Billing Address";}s:15:"sAccountComment";a:1:{s:5:"value";s:11:"Annotation:";}s:16:"sAccountcompany ";a:1:{s:5:"value";s:7:"Company";}s:16:"sAccountDownload";a:1:{s:5:"value";s:8:"Download";}s:19:"sAccountDownloadNow";a:1:{s:5:"value";s:12:"Download now";}s:29:"sAccountDownloadssortedbydate";a:1:{s:5:"value";s:29:"Your downloads sorted by date";}s:24:"sAccountErrorhasoccurred";a:1:{s:5:"value";s:22:"An Error has occurred!";}s:12:"sAccountFree";a:1:{s:5:"value";s:4:"FREE";}s:12:"sAccountfrom";a:1:{s:5:"value";s:5:"From:";}s:18:"sAccountgrandtotal";a:1:{s:5:"value";s:12:"Grand total:";}s:18:"sAccountIwanttoget";a:1:{s:5:"value";s:31:"Yes, I want to receive the free";}s:23:"sAccountmethodofpayment";a:1:{s:5:"value";s:15:"Choosen Payment";}s:14:"sAccountmodify";a:1:{s:5:"value";s:6:"Modify";}s:10:"sAccountMr";a:1:{s:5:"value";s:2:"Mr";}s:10:"sAccountMs";a:1:{s:5:"value";s:2:"Ms";}s:19:"sAccountNewPassword";a:1:{s:5:"value";s:14:"New password*:";}s:26:"sAccountnewslettersettings";a:1:{s:5:"value";s:24:"Your Newsletter settings";}s:14:"sAccountNumber";a:1:{s:5:"value";s:8:"Quantity";}s:21:"sAccountOrdercanceled";a:1:{s:5:"value";s:19:"Order was cancelled";}s:27:"sAccountOrderhasbeenshipped";a:1:{s:5:"value";s:22:"Order has been shipped";}s:23:"sAccountOrderinprogress";a:1:{s:5:"value";s:17:"Order in progress";}s:28:"sAccountOrdernotvetprocessed";a:1:{s:5:"value";s:32:"Order has not been processed yet";}s:19:"sAccountOrdernumber";a:1:{s:5:"value";s:12:"Ordernumber:";}s:29:"sAccountOrderpartiallyshipped";a:1:{s:5:"value";s:27:"Order was partially shipped";}s:26:"sAccountOrderssortedbydate";a:1:{s:5:"value";s:21:"Orders sorted by date";}s:18:"sAccountOrderTotal";a:1:{s:5:"value";s:12:"Order total:";}s:23:"sAccountPackagetracking";a:1:{s:5:"value";s:17:"Package tracking:";}s:12:"sAccountplus";a:1:{s:5:"value";s:4:"plus";}s:22:"sAccountRepeatpassword";a:1:{s:5:"value";s:17:"Repeat password*:";}s:16:"sAccountShipping";a:1:{s:5:"value";s:15:"Shipping costs:";}s:23:"sAccountshippingaddress";a:1:{s:5:"value";s:16:"Shipping address";}s:21:"sAccountthenewsletter";a:1:{s:5:"value";s:11:"Newsletter!";}s:13:"sAccountTotal";a:1:{s:5:"value";s:5:"Total";}s:17:"sAccountUnitprice";a:1:{s:5:"value";s:10:"Unit price";}s:22:"sAccountYouraccessdata";a:1:{s:5:"value";s:16:"Your access data";}s:24:"sAccountYouremailaddress";a:1:{s:5:"value";s:21:"Your e-mail address*:";}s:24:"sAccountyourSerialnumber";a:1:{s:5:"value";s:19:"Your Serial Number:";}s:26:"sAccountyourSerialnumberto";a:1:{s:5:"value";s:21:"Your Serial Number to";}s:19:"sAjaxcomparearticle";a:1:{s:5:"value";s:16:"Compared Article";}s:18:"sAjaxdeletecompare";a:1:{s:5:"value";s:14:"Delete Compare";}s:17:"sAjaxstartcompare";a:1:{s:5:"value";s:13:"Start Compare";}s:9:"sArticle1";a:1:{s:5:"value";s:12:"1 (very bad)";}s:10:"sArticle10";a:1:{s:5:"value";s:14:"10 (excellent)";}s:9:"sArticle2";a:1:{s:5:"value";s:1:"2";}s:9:"sArticle3";a:1:{s:5:"value";s:1:"3";}s:9:"sArticle4";a:1:{s:5:"value";s:1:"4";}s:9:"sArticle5";a:1:{s:5:"value";s:1:"5";}s:9:"sArticle6";a:1:{s:5:"value";s:1:"6";}s:9:"sArticle7";a:1:{s:5:"value";s:1:"7";}s:9:"sArticle8";a:1:{s:5:"value";s:1:"8";}s:9:"sArticle9";a:1:{s:5:"value";s:1:"9";}s:19:"sArticleaccessories";a:1:{s:5:"value";s:11:"Accessories";}s:19:"sArticleaddtobasked";a:1:{s:5:"value";s:11:"add to cart";}s:20:"sArticleaddtonotepad";a:1:{s:5:"value";s:16:"Add to favorites";}s:21:"sArticleafterageckeck";a:1:{s:5:"value";s:52:"Attention! Delivery only after successful age check!";}s:24:"sArticleallmanufacturers";a:1:{s:5:"value";s:22:"Show all manufacturers";}s:14:"sArticleamount";a:1:{s:5:"value";s:9:"Quantity:";}s:11:"sArticleand";a:1:{s:5:"value";s:3:"and";}s:22:"sArticlearticleperpage";a:1:{s:5:"value";s:16:"Article per page";}s:21:"sArticleavailableasan";a:1:{s:5:"value";s:34:"Available as an immediate download";}s:26:"sArticleavailabledownloads";a:1:{s:5:"value";s:20:"Available downloads:";}s:21:"sArticleAvailablefrom";a:1:{s:5:"value";s:12:"Available as";}s:26:"sArticleavailableimmediate";a:1:{s:5:"value";s:34:"Available as an immediate download";}s:12:"sArticleback";a:1:{s:5:"value";s:4:"Back";}s:20:"sArticleblockpricing";a:1:{s:5:"value";s:13:"Block pricing";}s:10:"sArticleby";a:1:{s:5:"value";s:3:"By:";}s:24:"sArticlechoosefirstexecu";a:1:{s:5:"value";s:32:"Attention! Choose version first!";}s:22:"sArticlecollectvoucher";a:1:{s:5:"value";s:34:"Tell a friend and catch a voucher!";}s:15:"sArticleCompare";a:1:{s:5:"value";s:7:"Compare";}s:23:"sArticlecustomerreviews";a:1:{s:5:"value";s:20:"Customer reviews for";}s:17:"sArticledatasheet";a:1:{s:5:"value";s:9:"Datasheet";}s:12:"sArticledays";a:1:{s:5:"value";s:4:"Days";}s:24:"sArticledaysshippingfree";a:1:{s:5:"value";s:14:"Shipping free!";}s:20:"sArticledeliverytime";a:1:{s:5:"value";s:13:"Shipping time";}s:19:"sArticledescription";a:1:{s:5:"value";s:11:"Description";}s:16:"sArticledownload";a:1:{s:5:"value";s:8:"Download";}s:19:"sArticleeightpoints";a:1:{s:5:"value";s:8:"8 Points";}s:23:"sArticleenterthenumbers";a:1:{s:5:"value";s:50:"Please enter the numbers in the following text box";}s:27:"sArticlefilloutallredfields";a:1:{s:5:"value";s:34:"Please fill in all required fields";}s:18:"sArticlefivepoints";a:1:{s:5:"value";s:8:"5 Points";}s:18:"sArticlefourpoints";a:1:{s:5:"value";s:8:"4 Points";}s:20:"sArticlefreeshipping";a:1:{s:5:"value";s:14:"Shipping Free!";}s:12:"sArticlefrom";a:1:{s:5:"value";s:4:"from";}s:26:"sArticlefurtherinformation";a:1:{s:5:"value";s:19:"further information";}s:19:"sArticlegetavoucher";a:1:{s:5:"value";s:16:"is your voucher*";}s:20:"sArticlehighestprice";a:1:{s:5:"value";s:13:"Highest Price";}s:12:"sArticleincl";a:1:{s:5:"value";s:5:"incl.";}s:19:"sArticleinthebasket";a:1:{s:5:"value";s:24:"add to you shopping cart";}s:17:"sArticleitemtitle";a:1:{s:5:"value";s:19:"Article description";}s:16:"sArticlelanguage";a:1:{s:5:"value";s:9:"Language:";}s:13:"sArticlelegal";a:1:{s:5:"value";s:5:"legal";}s:14:"sArticlelooked";a:1:{s:5:"value";s:11:"Last viewed";}s:19:"sArticlelowestprice";a:1:{s:5:"value";s:12:"Lowest Price";}s:19:"sArticlemainarticle";a:1:{s:5:"value";s:12:"Main article";}s:21:"sArticlematchingitems";a:1:{s:5:"value";s:27:"Frequently Bought Together:";}s:23:"sArticleMoreinformation";a:1:{s:5:"value";s:20:"Get more information";}s:28:"sArticlemoreinformationabout";a:1:{s:5:"value";s:26:"Get more information about";}s:11:"sArticlenew";a:1:{s:5:"value";s:3:"NEW";}s:12:"sArticlenext";a:1:{s:5:"value";s:4:"Next";}s:18:"sArticleninepoints";a:1:{s:5:"value";s:8:"9 Points";}s:17:"sArticlenoPicture";a:1:{s:5:"value";s:20:"No picture available";}s:10:"sArticleof";a:1:{s:5:"value";s:2:"by";}s:16:"sArticleonepoint";a:1:{s:5:"value";s:7:"1 Point";}s:19:"sArticleonesiteback";a:1:{s:5:"value";s:13:"One Site back";}s:22:"sArticleonesiteforward";a:1:{s:5:"value";s:16:"One Site forward";}s:20:"sArticleonthenotepad";a:1:{s:5:"value";s:16:"add to favorites";}s:19:"sArticleordernumber";a:1:{s:5:"value";s:10:"Order No.:";}s:23:"sArticleotherarticlesof";a:1:{s:5:"value";s:22:"Other articles made by";}s:20:"sArticleourcommenton";a:1:{s:5:"value";s:13:"Our review to";}s:11:"sArticleout";a:1:{s:5:"value";s:3:"out";}s:16:"sArticleoverview";a:1:{s:5:"value";s:8:"Overview";}s:20:"sArticlepleasechoose";a:1:{s:5:"value";s:16:"Please choose...";}s:25:"sArticlepleasecompleteall";a:1:{s:5:"value";s:34:"Please fill in all required fields";}s:20:"sArticlepleaseselect";a:1:{s:5:"value";s:16:"Please choose...";}s:18:"sArticlepopularity";a:1:{s:5:"value";s:11:"Bestselling";}s:14:"sArticleprices";a:1:{s:5:"value";s:6:"Prices";}s:18:"sArticleproductsof";a:1:{s:5:"value";s:16:"Products made by";}s:29:"sArticlequestionsaboutarticle";a:1:{s:5:"value";s:22:"Questions for article?";}s:22:"sArticlerecipientemail";a:1:{s:5:"value";s:22:"Receiver email address";}s:17:"sArticlerecommend";a:1:{s:5:"value";s:36:": tell a friend and catch a voucher!";}s:27:"sArticlerecommendandvoucher";a:1:{s:5:"value";s:32:"Tell a friend and get a voucher!";}s:16:"sArticlereleased";a:1:{s:5:"value";s:19:"unrated (universal)";}s:30:"sArticlereleasedafterverificat";a:1:{s:5:"value";s:44:"Reviews will be released after verification.";}s:19:"sArticlereleasedate";a:1:{s:5:"value";s:12:"Release Date";}s:27:"sArticlereleasedfrom12years";a:1:{s:5:"value";s:20:"Restricted 12 years+";}s:27:"sArticlereleasedfrom16years";a:1:{s:5:"value";s:20:"Restricted 16 years+";}s:27:"sArticlereleasedfrom18years";a:1:{s:5:"value";s:20:"Restricted 18 years+";}s:26:"sArticlereleasedfrom6years";a:1:{s:5:"value";s:24:"Restricted from 6 years+";}s:14:"sArticleReview";a:1:{s:5:"value";s:16:"Costumer Review:";}s:15:"sArticlereview1";a:1:{s:5:"value";s:16:"Costumer Review:";}s:15:"sArticlereviews";a:1:{s:5:"value";s:7:"Reviews";}s:12:"sArticlesave";a:1:{s:5:"value";s:5:"saved";}s:14:"sArticlescroll";a:1:{s:5:"value";s:6:"Scroll";}s:19:"sArticlesevenpoints";a:1:{s:5:"value";s:8:"7 Points";}s:16:"sArticleshipping";a:1:{s:5:"value";s:110:"<a href="{$sBasefile}?sViewport=custom&cCUSTOM=28" title="Shipping rates & policies">Shipping rates & policies";}s:27:"sArticleshippinginformation";a:1:{s:5:"value";s:33:"See our shipping rates & policies";}s:15:"sArticleshowall";a:1:{s:5:"value";s:8:"Show all";}s:28:"sArticleshowallmanufacturers";a:1:{s:5:"value";s:22:"Show all manufacturers";}s:23:"sArticlesimilararticles";a:1:{s:5:"value";s:15:"Suggested Items";}s:17:"sArticlesixpoints";a:1:{s:5:"value";s:8:"6 Points";}s:12:"sArticlesort";a:1:{s:5:"value";s:5:"Sort:";}s:15:"sArticlesummary";a:1:{s:5:"value";s:7:"Summary";}s:17:"sArticlesurcharge";a:1:{s:5:"value";s:17:"Additional charge";}s:26:"sArticlesystemrequirements";a:1:{s:5:"value";s:21:"Systemrequirement for";}s:15:"sArticletaxplus";a:1:{s:5:"value";s:8:"VAT plus";}s:16:"sArticletaxplus1";a:1:{s:5:"value";s:5:"VAT +";}s:17:"sArticletenpoints";a:1:{s:5:"value";s:9:"10 Points";}s:24:"sArticlethankyouverymuch";a:1:{s:5:"value";s:62:"Thank you very much. The recommendation was successfully sent.";}s:23:"sArticlethefieldsmarked";a:1:{s:5:"value";s:34:"Please fill in all required fields";}s:19:"sArticlethreepoints";a:1:{s:5:"value";s:8:"3 Points";}s:11:"sArticletip";a:1:{s:5:"value";s:4:"TIP!";}s:30:"sArticletipavailableasanimmedi";a:1:{s:5:"value";s:34:"Available as an immediate download";}s:26:"sArticletipmoreinformation";a:1:{s:5:"value";s:25:"Further information about";}s:29:"sArticletipproductinformation";a:1:{s:5:"value";s:19:"Product information";}s:11:"sArticletop";a:1:{s:5:"value";s:3:"TOP";}s:30:"sArticletopaveragecustomerrevi";a:1:{s:5:"value";s:17:"Customer Reviews:";}s:30:"sArticletopImmediatelyavailabl";a:1:{s:5:"value";s:8:"In Stock";}s:14:"sArticletosave";a:1:{s:5:"value";s:4:"Save";}s:25:"sArticletoseeinthepicture";a:1:{s:5:"value";s:16:"On this picture:";}s:17:"sArticletwopoints";a:1:{s:5:"value";s:8:"2 Points";}s:13:"sArticleuntil";a:1:{s:5:"value";s:5:"until";}s:17:"sArticleupdatenow";a:1:{s:5:"value";s:10:"Update now";}s:29:"sArticlewithoutagerestriction";a:1:{s:5:"value";s:23:"Without age restriction";}s:19:"sArticleworkingdays";a:1:{s:5:"value";s:10:"Workingday";}s:25:"sArticlewriteanassessment";a:1:{s:5:"value";s:15:"Create a review";}s:20:"sArticlewriteareview";a:1:{s:5:"value";s:15:"Create a review";}s:19:"sArticlewritereview";a:1:{s:5:"value";s:15:"Create a review";}s:19:"sArticleyourcomment";a:1:{s:5:"value";s:13:"Your comment:";}s:16:"sArticleyourname";a:1:{s:5:"value";s:9:"Your Name";}s:19:"sArticleyouropinion";a:1:{s:5:"value";s:13:"Your comment:";}s:18:"sArticlezeropoints";a:1:{s:5:"value";s:8:"0 Points";}s:23:"sBasketaddedtothebasket";a:1:{s:5:"value";s:32:"was added to your shopping cart!";}s:13:"sBasketamount";a:1:{s:5:"value";s:9:"Quantity:";}s:14:"sBasketArticle";a:1:{s:5:"value";s:7:"Article";}s:30:"sBasketarticlefromourcatalogue";a:1:{s:5:"value";s:29:"Add articles from our catalog";}s:22:"sBasketarticlenotfound";a:1:{s:5:"value";s:17:"Article not found";}s:20:"sBasketasanimmediate";a:1:{s:5:"value";s:34:"Available as an immediate download";}s:23:"sBasketasasmallthankyou";a:1:{s:5:"value";s:63:"As a small thank-you, you receive this article free in addition";}s:19:"sBasketavailability";a:1:{s:5:"value";s:8:"In Stock";}s:20:"sBasketavailablefrom";a:1:{s:5:"value";s:20:"Available from stock";}s:21:"sBasketbacktomainpage";a:1:{s:5:"value";s:17:"Back to Mainpage!";}s:21:"sBasketbasketdiscount";a:1:{s:5:"value";s:13:"Cart-discount";}s:30:"sBasketbetweenfollowingpremium";a:1:{s:5:"value";s:44:"Please choose between the following premiums";}s:15:"sBasketcheckout";a:1:{s:5:"value";s:8:"Checkout";}s:30:"sBasketcheckoutcustomerswithyo";a:1:{s:5:"value";s:45:"Customers Who Bought This Item Also Bought\n  ";}s:23:"sBasketcontinueshopping";a:1:{s:5:"value";s:17:"Continue shopping";}s:30:"sBasketcustomerswithyoursimila";a:1:{s:5:"value";s:48:"Customers Viewing This Page May Be Interested in";}s:30:"sBasketdeletethisitemfrombaske";a:1:{s:5:"value";s:34:"Erase this article from the basket";}s:15:"sBasketdelivery";a:1:{s:5:"value";s:13:"Shipping time";}s:22:"sBasketdeliverycountry";a:1:{s:5:"value";s:16:"Shipping country";}s:24:"sBasketdesignatedarticle";a:1:{s:5:"value";s:50:"Favorites - selected articles for a later purchase";}s:15:"sBasketdispatch";a:1:{s:5:"value";s:16:"Mode of shipment";}s:23:"sBasketerasefromnotepad";a:1:{s:5:"value";s:37:"Erase this article from the favorites";}s:25:"sBasketforwardingexpenses";a:1:{s:5:"value";s:25:"Shipping rates & policies";}s:11:"sBasketfree";a:1:{s:5:"value";s:5:"FREE!";}s:12:"sBasketfree1";a:1:{s:5:"value";s:4:"FREE";}s:11:"sBasketfrom";a:1:{s:5:"value";s:4:"from";}s:18:"sBasketinthebasket";a:1:{s:5:"value";s:20:"add to shopping cart";}s:20:"sBasketintothebasket";a:1:{s:5:"value";s:20:"Add to shopping cart";}s:28:"sBasketItautomaticallystores";a:1:{s:5:"value";s:126:"automatically stores your personal favorite-list.\nYou can comfortably retrieve your registered articles in a subsequent visit.";}s:26:"sBasketjustthedesireditems";a:1:{s:5:"value";s:56:"Put simply the desired articles on the favorite-list and";}s:23:"sBasketlastinyourbasket";a:1:{s:5:"value";s:32:"Last article added in your cart:";}s:24:"sBasketminimumordervalue";a:1:{s:5:"value";s:37:"Attention. The minimum order value of";}s:13:"sBasketmodify";a:1:{s:5:"value";s:6:"Modify";}s:23:"sBasketmoreinformations";a:1:{s:5:"value";s:16:"More information";}s:27:"sBasketnoitemsonyournotepad";a:1:{s:5:"value";s:45:"There are no articles on your favorites-list.";}s:25:"sBasketnopictureavailable";a:1:{s:5:"value";s:20:"No picture available";}s:14:"sBasketnotepad";a:1:{s:5:"value";s:9:"Favorites";}s:20:"sBasketnotreachedyet";a:1:{s:5:"value";s:19:"is not reached yet!";}s:13:"sBasketnumber";a:1:{s:5:"value";s:8:"Quantity";}s:18:"sBasketordernumber";a:1:{s:5:"value";s:9:"Order No.";}s:14:"sBasketpayment";a:1:{s:5:"value";s:17:"Method of Payment";}s:19:"sBasketpleasechoose";a:1:{s:5:"value";s:16:"Please choose...";}s:23:"sBasketrecalculateprice";a:1:{s:5:"value";s:31:"Recalculate price - update cart";}s:26:"sBasketsaveyourpersonalfav";a:1:{s:5:"value";s:60:"Save your personal favorites - until you visit us next time.";}s:17:"sBasketshowbasket";a:1:{s:5:"value";s:18:"Show shopping cart";}s:18:"sBasketstep1basket";a:1:{s:5:"value";s:21:"Step1 - Shopping Cart";}s:15:"sBasketsubtotal";a:1:{s:5:"value";s:9:"Subtotal:";}s:10:"sBasketsum";a:1:{s:5:"value";s:5:"Total";}s:17:"sBaskettocheckout";a:1:{s:5:"value";s:9:"Checkout!";}s:15:"sBaskettotalsum";a:1:{s:5:"value";s:5:"Total";}s:16:"sBasketunitprice";a:1:{s:5:"value";s:10:"Unit price";}s:15:"sBasketweekdays";a:1:{s:5:"value";s:8:"Workdays";}s:17:"sBasketyourbasket";a:1:{s:5:"value";s:18:"Your shopping cart";}s:24:"sBasketyourbasketisempty";a:1:{s:5:"value";s:43:"There are no articles in your shopping cart";}s:21:"sCategorymanufacturer";a:1:{s:5:"value";s:12:"Manufacturer";}s:18:"sCategorynopicture";a:1:{s:5:"value";s:20:"No picture available";}s:26:"sCategoryothermanufacturer";a:1:{s:5:"value";s:19:"Other manufacturers";}s:16:"sCategoryshowall";a:1:{s:5:"value";s:8:"Show all";}s:18:"sCategorytopseller";a:1:{s:5:"value";s:9:"Topseller";}s:18:"sContentattachment";a:1:{s:5:"value";s:11:"Attachment:";}s:12:"sContentback";a:1:{s:5:"value";s:4:"Back";}s:14:"sContentbrowse";a:1:{s:5:"value";s:7:"Browse:";}s:21:"sContentbrowseforward";a:1:{s:5:"value";s:14:"Browse forward";}s:26:"sContentcurrentlynoentries";a:1:{s:5:"value";s:30:"Currently no entries available";}s:16:"sContentdownload";a:1:{s:5:"value";s:8:"Download";}s:21:"sContententrynotfound";a:1:{s:5:"value";s:14:"No entry found";}s:21:"sContentgobackonepage";a:1:{s:5:"value";s:16:"Browse backward ";}s:12:"sContentmore";a:1:{s:5:"value";s:6:"[more]";}s:24:"sContentmoreinformations";a:1:{s:5:"value";s:17:"More information:";}s:21:"sContentonthispicture";a:1:{s:5:"value";s:16:"On this picture:";}s:20:"sCustomdirectcontact";a:1:{s:5:"value";s:14:"Direct contact";}s:19:"sCustomsitenotfound";a:1:{s:5:"value";s:14:"Page not found";}s:19:"sErrorBillingAdress";a:1:{s:5:"value";s:40:"Please fill out all fields marked in red";}s:14:"sErrorcheckout";a:1:{s:5:"value";s:8:"Checkout";}s:21:"sErrorCookiesDisabled";a:1:{s:5:"value";s:66:"To use this feature, you must have cookies enabled in your browser";}s:11:"sErrorEmail";a:1:{s:5:"value";s:35:"Please enter a valid e-mail address";}s:19:"sErrorEmailForgiven";a:1:{s:5:"value";s:40:"This email address is already registered";}s:19:"sErrorEmailNotFound";a:1:{s:5:"value";s:33:"This e-mail address was not found";}s:11:"sErrorerror";a:1:{s:5:"value";s:21:"An error has occurred";}s:23:"sErrorForgotMailUnknown";a:1:{s:5:"value";s:28:"This mail address is unknown";}s:10:"sErrorhome";a:1:{s:5:"value";s:4:"Home";}s:11:"sErrorLogin";a:1:{s:5:"value";s:50:"Your access data could not be assigned to any user";}s:23:"sErrorMerchantNotActive";a:1:{s:5:"value";s:73:"You are not registered as a reseller or your account has not approved yet";}s:29:"sErrormoreinterestingarticles";a:1:{s:5:"value";s:17:"You may also like";}s:22:"sErrororderwascanceled";a:1:{s:5:"value";s:22:"The order was canceled";}s:14:"sErrorPassword";a:1:{s:5:"value";s:57:"Please choose a password consisting at least 6 characters";}s:21:"sErrorShippingAddress";a:1:{s:5:"value";s:40:"Please fill out all fields marked in red";}s:27:"sErrorthisarticleisnolonger";a:1:{s:5:"value";s:34:"The product has been discontinued!";}s:12:"sErrorUnknow";a:1:{s:5:"value";s:29:"An unknown error has occurred";}s:16:"sErrorValidEmail";a:1:{s:5:"value";s:35:"Please enter a valid e-mail address";}s:13:"sIndexaccount";a:1:{s:5:"value";s:10:"My Account";}s:16:"sIndexactivation";a:1:{s:5:"value";s:284:"3. Activation: As soon as both satisfactory forms are given to us and provided that your signatures match, we switch you for plays from 18 freely. Afterwards we immediately send you a confirmation email. Then you can quite simply order the USK 18 title comfortably about the web shop.";}s:25:"sIndexallpricesexcludevat";a:1:{s:5:"value";s:28:"* All prices exclude VAT and";}s:25:"sIndexandpossibledelivery";a:1:{s:5:"value";s:50:"and possibly shipping fees unless otherwise stated";}s:12:"sIndexappear";a:1:{s:5:"value";s:9:"Released:";}s:13:"sIndexarticle";a:1:{s:5:"value";s:10:"article(s)";}s:19:"sIndexarticlesfound";a:1:{s:5:"value";s:18:" article(s) found!";}s:24:"sIndexavailabledownloads";a:1:{s:5:"value";s:20:"Available downloads:";}s:16:"sIndexbacktohome";a:1:{s:5:"value";s:12:"back to home";}s:12:"sIndexbasket";a:1:{s:5:"value";s:16:"My shopping cart";}s:25:"sIndexcertifiedonlineshop";a:1:{s:5:"value";s:113:"Trusted Shops certified online shop with money-back guarantee. Click on the seal in order to verify the validity.";}s:26:"sIndexchangebillingaddress";a:1:{s:5:"value";s:22:"Change billing address";}s:27:"sIndexchangedeliveryaddress";a:1:{s:5:"value";s:23:"Change delivery address";}s:19:"sIndexchangepayment";a:1:{s:5:"value";s:24:"Change method of payment";}s:19:"sIndexclientaccount";a:1:{s:5:"value";s:16:"Customer account";}s:26:"sIndexcompareupto5articles";a:1:{s:5:"value";s:42:"You can compare up to 5 items in one step!";}s:15:"sIndexcopyright";a:1:{s:5:"value";s:51:"Copyright © 2008 shopware.ag - All rights reserved.";}s:11:"sIndexcover";a:1:{s:5:"value";s:6:"Cover:";}s:14:"sIndexcurrency";a:1:{s:5:"value";s:9:"Currency:";}s:14:"sIndexdownload";a:1:{s:5:"value";s:8:"Download";}s:13:"sIndexenglish";a:1:{s:5:"value";s:7:"English";}s:11:"sIndexextra";a:1:{s:5:"value";s:7:"Extras:";}s:28:"sIndexforreasonofinformation";a:1:{s:5:"value";s:477:"For reasons of information we display in our online shop also games which own no gift suitable for young people. However, there is a way for customers, who have already completed the eighteenth year,  to purchase these games. Now you can order with us also quite simply USK 18 games above the postal dispatch way. To fulfil the requirements of the protection of children and young people-sedate you must be personalised in addition simply by Postident. The way is quite simply:";}s:12:"sIndexfrench";a:1:{s:5:"value";s:6:"French";}s:10:"sIndexfrom";a:1:{s:5:"value";s:4:"from";}s:12:"sIndexgerman";a:1:{s:5:"value";s:6:"German";}s:11:"sIndexhello";a:1:{s:5:"value";s:5:"Hello";}s:10:"sIndexhome";a:1:{s:5:"value";s:4:"Home";}s:20:"sIndexhowcaniacquire";a:1:{s:5:"value";s:68:"How can i acquire the games which are restricted only from 18 years?";}s:14:"sIndexlanguage";a:1:{s:5:"value";s:9:"Language:";}s:12:"sIndexlogout";a:1:{s:5:"value";s:6:"Logout";}s:14:"sIndexmybasket";a:1:{s:5:"value";s:12:"Show my cart";}s:24:"sIndexmyinstantdownloads";a:1:{s:5:"value";s:20:"My instant downloads";}s:14:"sIndexmyorders";a:1:{s:5:"value";s:9:"My orders";}s:22:"sIndexnoagerestriction";a:1:{s:5:"value";s:23:"Without age restriction";}s:13:"sIndexnotepad";a:1:{s:5:"value";s:9:"Favorites";}s:18:"sIndexonthepicture";a:1:{s:5:"value";s:16:"On this picture:";}s:17:"sIndexordernumber";a:1:{s:5:"value";s:10:"Order no.:";}s:18:"sIndexourcommentto";a:1:{s:5:"value";s:13:"Our review on";}s:14:"sIndexoverview";a:1:{s:5:"value";s:8:"Overview";}s:16:"sIndexpagenumber";a:1:{s:5:"value";s:11:"Pagenumber:";}s:26:"sIndexpossiblydeliveryfees";a:1:{s:5:"value";s:50:"and possibly shipping fees unless otherwise stated";}s:15:"sIndexpostident";a:1:{s:5:"value";s:171:"2. POSTIDENT: The German post provides a POSTIDENT form in the confirmation of your majority. Please, sign this also. Then the German post sends both signed documents to .";}s:19:"sIndexpricesinclvat";a:1:{s:5:"value";s:27:"* All prices incl. VAT plus";}s:14:"sIndexprinting";a:1:{s:5:"value";s:6:"Print:";}s:25:"sIndexproductinformations";a:1:{s:5:"value";s:19:"Product information";}s:18:"sIndexrealizedwith";a:1:{s:5:"value";s:13:"realised with";}s:30:"sIndexrealizedwiththeshopsyste";a:1:{s:5:"value";s:57:"realized by shopware ag an the webshop-software Shopware ";}s:14:"sIndexreleased";a:1:{s:5:"value";s:19:"unrated (universal)";}s:25:"sIndexreleasedfrom12years";a:1:{s:5:"value";s:20:"Restricted 12 years+";}s:25:"sIndexreleasedfrom16years";a:1:{s:5:"value";s:20:"Restricted 16 years+";}s:25:"sIndexreleasedfrom18years";a:1:{s:5:"value";s:20:"Restricted 18 years+";}s:24:"sIndexreleasedfrom6years";a:1:{s:5:"value";s:19:"Restricted 6 years+";}s:12:"sIndexsearch";a:1:{s:5:"value";s:0:"";}s:14:"sIndexshipping";a:1:{s:5:"value";s:14:"Shipping rates";}s:14:"sIndexshopware";a:1:{s:5:"value";s:8:"Shopware";}s:17:"sIndexshownotepad";a:1:{s:5:"value";s:14:"Show favorites";}s:21:"sIndexsimilararticles";a:1:{s:5:"value";s:15:"Suggested Items";}s:10:"sIndexsite";a:1:{s:5:"value";s:4:"Page";}s:22:"sIndexsuitablearticles";a:1:{s:5:"value";s:16:"Suggested Items:";}s:27:"sIndexsystemrequirementsfor";a:1:{s:5:"value";s:22:"System requirement for";}s:8:"sIndexto";a:1:{s:5:"value";s:2:"To";}s:23:"sIndextrustedshopslabel";a:1:{s:5:"value";s:61:"Trusted shops stamp of quality - request validity check here!";}s:19:"sIndexviewmyaccount";a:1:{s:5:"value";s:16:"Visit my account";}s:19:"sIndexwelcometoyour";a:1:{s:5:"value";s:28:"and welcome to your personal";}s:10:"sIndexwere";a:1:{s:5:"value";s:4:"were";}s:16:"sIndexyouarehere";a:1:{s:5:"value";s:13:"You are here:";}s:19:"sIndexyouloadthepdf";a:1:{s:5:"value";s:222:"1. Load the PDF registration form in your customer area and print it out. Please, present this form together with your identity card or passport in a branch of the German post. Mark the appropriate field and sign the form.";}s:26:"sInfoEmailAlreadyRegiested";a:1:{s:5:"value";s:34:"You already receive our newsletter";}s:26:"sLoginalreadyhaveanaccount";a:1:{s:5:"value";s:25:"I am a returning customer";}s:15:"sLoginareyounew";a:1:{s:5:"value";s:27:"New customer? Start here at";}s:10:"sLoginback";a:1:{s:5:"value";s:4:"Back";}s:18:"sLogindealeraccess";a:1:{s:5:"value";s:16:"Reseller account";}s:11:"sLoginerror";a:1:{s:5:"value";s:22:"An error has occurred!";}s:24:"sLoginloginwithyouremail";a:1:{s:5:"value";s:50:"Please login using your eMail address and password";}s:18:"sLoginlostpassword";a:1:{s:5:"value";s:21:"Forgot your password?";}s:28:"sLoginlostpasswordhereyoucan";a:1:{s:5:"value";s:57:"Forgot your password? Here you can request a new password";}s:17:"sLoginnewcustomer";a:1:{s:5:"value";s:12:"New customer";}s:28:"sLoginnewpasswordhasbeensent";a:1:{s:5:"value";s:38:"Your new password has been sent to you";}s:15:"sLoginnoproblem";a:1:{s:5:"value";s:91:"No problem, ordering from us is easy and secure. The registration takes only a few moments.";}s:14:"sLoginpassword";a:1:{s:5:"value";s:14:"Your password:";}s:17:"sLoginregisternow";a:1:{s:5:"value";s:12:"Register now";}s:16:"sLoginstep1login";a:1:{s:5:"value";s:26:"Step1 - Login/Registration";}s:27:"sLoginwewillsendyouanewpass";a:1:{s:5:"value";s:94:"We will send you a new, randomly generated password. This can be changed in the customer area.";}s:21:"sLoginyouremailadress";a:1:{s:5:"value";s:20:"Your e-mail address:";}s:27:"sOrderprocessacceptourterms";a:1:{s:5:"value";s:46:"Please accept our general terms and conditions";}s:19:"sOrderprocessamount";a:1:{s:5:"value";s:8:"Quantity";}s:20:"sOrderprocessarticle";a:1:{s:5:"value";s:7:"Article";}s:26:"sOrderprocessbillingadress";a:1:{s:5:"value";s:72:"You can change billing address, shipping address and payment method now.";}s:27:"sOrderprocessbillingadress1";a:1:{s:5:"value";s:15:"Billing address";}s:19:"sOrderprocesschange";a:1:{s:5:"value";s:6:"Change";}s:25:"sOrderprocesschangebasket";a:1:{s:5:"value";s:20:"Change shopping cart";}s:30:"sOrderprocesschangeyourpayment";a:1:{s:5:"value";s:122:"Please change your payment method. The purchase of instant downloads is currently not possible with your selected payment!";}s:22:"sOrderprocessclickhere";a:1:{s:5:"value";s:44:"Trusted Shops stamp of quality - click here.";}s:20:"sOrderprocesscomment";a:1:{s:5:"value";s:11:"Annotation:";}s:20:"sOrderprocesscompany";a:1:{s:5:"value";s:7:"Company";}s:28:"sOrderprocessdeliveryaddress";a:1:{s:5:"value";s:16:"Shipping address";}s:21:"sOrderprocessdispatch";a:1:{s:5:"value";s:16:"Shipping method:";}s:25:"sOrderprocessdoesnotreach";a:1:{s:5:"value";s:16:"not reached yet!";}s:28:"sOrderprocessenteradditional";a:1:{s:5:"value";s:57:"Please, give here additional information about your order";}s:30:"sOrderprocessforwardingexpense";a:1:{s:5:"value";s:15:"Shipping costs:";}s:25:"sOrderprocessforyourorder";a:1:{s:5:"value";s:28:"Thank you for your order at ";}s:17:"sOrderprocessfree";a:1:{s:5:"value";s:4:"FREE";}s:26:"sOrderprocessimportantinfo";a:1:{s:5:"value";s:45:"Important information to the shipping country";}s:30:"sOrderprocessinformationsabout";a:1:{s:5:"value";s:30:"Informations about your order:";}s:27:"sOrderprocessmakethepayment";a:1:{s:5:"value";s:15:"Please pay now:";}s:30:"sOrderprocessminimumordervalue";a:1:{s:5:"value";s:46:"Attention. You have the minimum order value of";}s:15:"sOrderprocessmr";a:1:{s:5:"value";s:2:"Mr";}s:15:"sOrderprocessms";a:1:{s:5:"value";s:2:"Ms";}s:21:"sOrderprocessnettotal";a:1:{s:5:"value";s:10:"Net total:";}s:24:"sOrderprocessordernumber";a:1:{s:5:"value";s:13:"Order number:";}s:30:"sOrderprocessperorderonevouche";a:1:{s:5:"value";s:41:"Per order max. one voucher can be cashed.";}s:24:"sOrderprocesspleasecheck";a:1:{s:5:"value";s:50:"Please, check your order again, before sending it.";}s:18:"sOrderprocessprice";a:1:{s:5:"value";s:5:"Price";}s:18:"sOrderprocessprint";a:1:{s:5:"value";s:5:"Print";}s:27:"sOrderprocessprintorderconf";a:1:{s:5:"value";s:33:"Print out order confirmation now!";}s:29:"sOrderprocessrecommendtoprint";a:1:{s:5:"value";s:55:"We recommend to print out the order confirmation below.";}s:23:"sOrderprocessrevocation";a:1:{s:5:"value";s:18:"Right of withdrawl";}s:26:"sOrderprocesssameappliesto";a:1:{s:5:"value";s:42:"The same applies to the selected articles.";}s:28:"sOrderprocessselectedpayment";a:1:{s:5:"value";s:22:"Choosen payment method";}s:30:"sOrderprocessspecifythetransfe";a:1:{s:5:"value";s:60:"Please, give by the referral the following intended purpose:";}s:25:"sOrderprocesstotalinclvat";a:1:{s:5:"value";s:16:"Total incl. VAT:";}s:23:"sOrderprocesstotalprice";a:1:{s:5:"value";s:5:"Total";}s:29:"sOrderprocesstransactionumber";a:1:{s:5:"value";s:19:"Transaction number:";}s:30:"sOrderprocesstrustedshopmember";a:1:{s:5:"value";s:155:"As a member of Trusted Shops, we offer a\n     additional money-back guarantee. We take all\n     Cost of this warranty, you only need to be\n     registered.";}s:26:"sOrderprocessvouchernumber";a:1:{s:5:"value";s:15:"Voucher number:";}s:27:"sOrderprocesswehaveprovided";a:1:{s:5:"value";s:48:"We have sent you an order confirmation by eMail.";}s:28:"sOrderprocessyourvouchercode";a:1:{s:5:"value";s:62:"Please, enter your voucher code here and click on the "arrow".";}s:21:"sPaymentaccountnumber";a:1:{s:5:"value";s:16:"Account number*:";}s:22:"sPaymentbankcodenumber";a:1:{s:5:"value";s:17:"Bank code number:";}s:28:"sPaymentchooseyourcreditcard";a:1:{s:5:"value";s:26:"Choose your credit card *:";}s:24:"sPaymentcreditcardnumber";a:1:{s:5:"value";s:26:"Your credit card number *:";}s:25:"sPaymentcurrentlyselected";a:1:{s:5:"value";s:18:"Currently selected";}s:26:"sPaymentcurrentlyselected1";a:1:{s:5:"value";s:18:"Currently Selected";}s:11:"sPaymentEsd";a:1:{s:5:"value";s:14:"online banking";}s:23:"sPaymentmarkedfieldsare";a:1:{s:5:"value";s:43:"Please fill in all required address fields.";}s:13:"sPaymentmonth";a:1:{s:5:"value";s:5:"Month";}s:24:"sPaymentnameofcardholder";a:1:{s:5:"value";s:20:"Name of cardholder*:";}s:16:"sPaymentshipping";a:1:{s:5:"value";s:25:"Shipping rates & policies";}s:18:"sPaymentvaliduntil";a:1:{s:5:"value";s:14:"Valid until *:";}s:12:"sPaymentyear";a:1:{s:5:"value";s:4:"Year";}s:16:"sPaymentyourbank";a:1:{s:5:"value";s:11:"Your Bank*:";}s:22:"sPaymentyourcreditcard";a:1:{s:5:"value";s:15:"Your creditcard";}s:19:"sRegisteraccessdata";a:1:{s:5:"value";s:10:"Your Login";}s:25:"sRegisterafterregistering";a:1:{s:5:"value";s:79:"Once your account is approved, you will see your reseller prices in this shop.\n";}s:30:"sRegisteralreadyhaveatraderacc";a:1:{s:5:"value";s:36:"You have already a reseller account?";}s:13:"sRegisterback";a:1:{s:5:"value";s:4:"Back";}s:18:"sRegisterbirthdate";a:1:{s:5:"value";s:10:"Birthdate:";}s:19:"sRegistercharacters";a:1:{s:5:"value";s:11:"Characters.";}s:19:"sRegistercityandzip";a:1:{s:5:"value";s:22:"Postal Code and City*:";}s:25:"sRegisterclickheretologin";a:1:{s:5:"value";s:20:"Click here to log in";}s:16:"sRegistercompany";a:1:{s:5:"value";s:8:"Company:";}s:22:"sRegisterconsiderupper";a:1:{s:5:"value";s:31:"Consider upper and lower case. ";}s:16:"sRegistercountry";a:1:{s:5:"value";s:9:"Country*:";}s:19:"sRegisterdepartment";a:1:{s:5:"value";s:11:"Department:";}s:29:"sRegisterenterdeliveryaddress";a:1:{s:5:"value";s:29:"Enter a delivery address here";}s:22:"sRegistererroroccurred";a:1:{s:5:"value";s:22:"An error has occurred!";}s:12:"sRegisterfax";a:1:{s:5:"value";s:4:"Fax:";}s:21:"sRegisterfieldsmarked";a:1:{s:5:"value";s:18:"* required fields.";}s:18:"sRegisterfirstname";a:1:{s:5:"value";s:13:"First name *:";}s:22:"sRegisterforavatexempt";a:1:{s:5:"value";s:89:"Enter a VAT number to remove tax for orders being delivered to a country outside the EU. ";}s:23:"sRegisterfreetextfields";a:1:{s:5:"value";s:44:"Additional Info: (for example: mobile phone)";}s:20:"sRegisterinthefuture";a:1:{s:5:"value";s:59:"Please SET up your account so that you can see your orders.";}s:17:"sRegisterlastname";a:1:{s:5:"value";s:11:"Last name*:";}s:11:"sRegistermr";a:1:{s:5:"value";s:3:"Mr.";}s:11:"sRegisterms";a:1:{s:5:"value";s:3:"Ms.";}s:13:"sRegisternext";a:1:{s:5:"value";s:4:"Next";}s:26:"sRegisternocustomeraccount";a:1:{s:5:"value";s:30:"Do not open a customer account";}s:29:"sRegisteronthisfollowingpages";a:1:{s:5:"value";s:0:"";}s:14:"sRegisterphone";a:1:{s:5:"value";s:7:"Phone*:";}s:21:"sRegisterpleasechoose";a:1:{s:5:"value";s:14:"Please choose:";}s:21:"sRegisterpleaseselect";a:1:{s:5:"value";s:17:"Please choose...\n";}s:27:"sRegisterrepeatyourpassword";a:1:{s:5:"value";s:22:"Repeat your password*:";}s:19:"sRegisterrevocation";a:1:{s:5:"value";s:18:"Right of withdrawl";}s:13:"sRegistersave";a:1:{s:5:"value";s:4:"Save";}s:22:"sRegisterselectpayment";a:1:{s:5:"value";s:43:"Please choose your preferred payment method";}s:29:"sRegistersendusyourtradeproof";a:1:{s:5:"value";s:28:"Fax your VAT number to us at";}s:30:"sRegistersendusyourtradeproofb";a:1:{s:5:"value";s:151:"Send your VAT number by fax to +49 2555 99 75 0 99.\nIf you are already a registered re-seller, you can skip this part. You don´t have to send it again.";}s:25:"sRegisterseperatedelivery";a:1:{s:5:"value";s:50:"I would like to enter a different delivery address";}s:30:"sRegistershippingaddressdiffer";a:1:{s:5:"value";s:56:"Your shipping address differs from your billing address.";}s:24:"sRegisterstreetandnumber";a:1:{s:5:"value";s:16:"Street and No.*:";}s:28:"sRegistersubscribenewsletter";a:1:{s:5:"value";s:26:"Sign up for our newsletter";}s:14:"sRegistertitle";a:1:{s:5:"value";s:7:"Title*:";}s:27:"sRegistertraderregistration";a:1:{s:5:"value";s:21:"Reseller Registration";}s:14:"sRegistervatid";a:1:{s:5:"value";s:11:"VAT number:";}s:16:"sRegisterwecheck";a:1:{s:5:"value";s:49:"After verification your account will be approved.";}s:27:"sRegisterwecheckyouastrader";a:1:{s:5:"value";s:212:"After verification your account will be approved. After clearing you get informations per eMail.\nFrom now on, you´ll see your special reseller prices directly, displayed on the product-detail- and overview-pages.";}s:24:"sRegisteryouraccountdata";a:1:{s:5:"value";s:17:"Your billing data";}s:18:"sRegisteryouremail";a:1:{s:5:"value";s:20:"Your eMail-address*:";}s:21:"sRegisteryourpassword";a:1:{s:5:"value";s:15:"Your password*:";}s:27:"sRegisteryourpasswordatlast";a:1:{s:5:"value";s:33:"Your password needs a minimum of ";}s:19:"sSearchafterfilters";a:1:{s:5:"value";s:9:"by filter";}s:20:"sSearchallcategories";a:1:{s:5:"value";s:19:"Show all categories";}s:17:"sSearchallfilters";a:1:{s:5:"value";s:11:"All filters";}s:22:"sSearchallmanufacturer";a:1:{s:5:"value";s:17:"All Manufacturers";}s:16:"sSearchallprices";a:1:{s:5:"value";s:10:"All Prices";}s:20:"sSearcharticlesfound";a:1:{s:5:"value";s:18:" article(s) found!";}s:22:"sSearcharticlesperpage";a:1:{s:5:"value";s:18:"Articles per page:";}s:13:"sSearchbrowse";a:1:{s:5:"value";s:7:"Browse:";}s:21:"sSearchbymanufacturer";a:1:{s:5:"value";s:15:"by manufacturer";}s:14:"sSearchbyprice";a:1:{s:5:"value";s:8:"by price";}s:14:"sSearchelected";a:1:{s:5:"value";s:8:"Choosen:";}s:19:"sSearchhighestprice";a:1:{s:5:"value";s:13:"Highest price";}s:16:"sSearchitemtitle";a:1:{s:5:"value";s:19:"Article description";}s:18:"sSearchlowestprice";a:1:{s:5:"value";s:12:"Lowest price";}s:15:"sSearchnextpage";a:1:{s:5:"value";s:9:"Next page";}s:22:"sSearchnoarticlesfound";a:1:{s:5:"value";s:42:"Your search did not match to any articles!";}s:18:"sSearchonepageback";a:1:{s:5:"value";s:13:"One page back";}s:25:"sSearchothermanufacturers";a:1:{s:5:"value";s:20:"Other manufacturers:";}s:17:"sSearchpopularity";a:1:{s:5:"value";s:11:"Bestselling";}s:18:"sSearchreleasedate";a:1:{s:5:"value";s:12:"Release date";}s:16:"sSearchrelevance";a:1:{s:5:"value";s:9:"Relevance";}s:23:"sSearchsearchcategories";a:1:{s:5:"value";s:20:"Search by categories";}s:19:"sSearchsearchresult";a:1:{s:5:"value";s:16:"Search result(s)";}s:25:"sSearchsearchtermtooshort";a:1:{s:5:"value";s:37:"The entered search term is too short.";}s:14:"sSearchshowall";a:1:{s:5:"value";s:8:"Show all";}s:11:"sSearchsort";a:1:{s:5:"value";s:5:"Sort:";}s:9:"sSearchto";a:1:{s:5:"value";s:2:"to";}s:29:"sSearchunfortunatelytherewere";a:1:{s:5:"value";s:38:"unfortunately no entries were found to";}s:11:"sSearchwere";a:1:{s:5:"value";s:4:"were";}s:24:"sSupportallmanufacturers";a:1:{s:5:"value";s:22:"List all manufacturers";}s:22:"sSupportarticleperpage";a:1:{s:5:"value";s:18:"Articles per page:";}s:12:"sSupportback";a:1:{s:5:"value";s:4:"Back";}s:14:"sSupportbrowse";a:1:{s:5:"value";s:7:"Browse:";}s:23:"sSupportenterthenumbers";a:1:{s:5:"value";s:52:"Please enter the numbers into the following text box";}s:21:"sSupportentrynotfound";a:1:{s:5:"value";s:15:"No Entry found.";}s:24:"sSupportfieldsmarketwith";a:1:{s:5:"value";s:43:"Please fill in all required address fields.";}s:20:"sSupporthighestprice";a:1:{s:5:"value";s:13:"Highest price";}s:17:"sSupportitemtitle";a:1:{s:5:"value";s:19:"Article description";}s:19:"sSupportlowestprice";a:1:{s:5:"value";s:12:"Lowest price";}s:16:"sSupportnextpage";a:1:{s:5:"value";s:16:"One page forward";}s:19:"sSupportonepageback";a:1:{s:5:"value";s:13:"One page back";}s:18:"sSupportpopularity";a:1:{s:5:"value";s:11:"Bestselling";}s:19:"sSupportreleasedate";a:1:{s:5:"value";s:12:"Release date";}s:12:"sSupportsend";a:1:{s:5:"value";s:4:"Send";}s:12:"sSupportsort";a:1:{s:5:"value";s:8:"sort by:";}s:21:"sVoucherAlreadyCashed";a:1:{s:5:"value";s:53:"This voucher was already cashed with a previous order";}s:23:"sVoucherBoundToSupplier";a:1:{s:5:"value";s:56:"This voucher is valid only for products from {sSupplier}";}s:21:"sVoucherMinimumCharge";a:1:{s:5:"value";s:64:"The minimum turnover for this voucher amounts {sMinimumCharge} ?";}s:16:"sVoucherNotFound";a:1:{s:5:"value";s:51:"Voucher could not be found or is not valid any more";}s:23:"sVoucherOnlyOnePerOrder";a:1:{s:5:"value";s:40:"Per order only one voucher can be cashed";}s:26:"sVoucherWrongCustomergroup";a:1:{s:5:"value";s:52:"This coupon is not available for your customer group";}s:25:"sArticleinformationsabout";a:1:{s:5:"value";s:47:"Information about restricted 18 years+-articles";}s:27:"sArticlethevoucherautomatic";a:1:{s:5:"value";s:209:"* The voucher will be delivered automatically to you by eMail after registration and the first order of your friend. You have to be registered with the choosen email address in the shop to receive the voucher.";}s:18:"sBasketrecalculate";a:1:{s:5:"value";s:11:"Recalculate";}s:11:"sLoginlogin";a:1:{s:5:"value";s:5:"Login";}s:25:"sOrderprocesssendordernow";a:1:{s:5:"value";s:14:"Send order now";}s:28:"sOrderprocessforthemoneyback";a:1:{s:5:"value";s:41:"Registration for the money-back guarantee";}s:17:"sSearchcategories";a:1:{s:5:"value";s:11:"Categories:";}s:19:"sSearchmanufacturer";a:1:{s:5:"value";s:13:"Manufacturer:";}s:21:"sSearchshowallresults";a:1:{s:5:"value";s:16:"Show all results";}s:21:"sSearchnosearchengine";a:1:{s:5:"value";s:24:"No search engine support";}s:27:"sSupportfilloutallredfields";a:1:{s:5:"value";s:38:"Please fill out all red marked fields.";}s:12:"sArticlesend";a:1:{s:5:"value";s:4:"Send";}s:14:"sContact_right";a:1:{s:5:"value";s:72:"<strong>Demoshop<br />\n</strong><br />\nAdd your contact information here";}s:12:"sBankContact";a:1:{s:5:"value";s:71:"<strong>\nOur bank:\n</strong>\nVolksbank Musterstadt\nBIN:\nAccount number:";}s:11:"sArticleof1";a:1:{s:5:"value";s:2:"of";}s:25:"sBasketshippingdifference";a:1:{s:5:"value";s:49:"Order #1 #2 to get the whole order shipping free!";}s:19:"sRegister_advantage";a:1:{s:5:"value";s:218:"<h2>My advantages</h2>\n<ul>\n<li>faster shopping</li>\n<li>Save your user data and settings</li>\n<li>Have a look at your orders including shipping information</li>\n<li>Administrate your newsletter subscription</li>\n</ul>";}s:20:"sArticlePricePerUnit";a:1:{s:5:"value";s:14:"Price per unit";}s:18:"sArticleLastViewed";a:1:{s:5:"value";s:11:"Last viewed";}s:16:"sBasketLessStock";a:1:{s:5:"value";s:57:"Unfortunately there are not enough articles left in stock";}s:20:"sBasketLessStockRest";a:1:{s:5:"value";s:76:"Unfortunately there are not enough articles left in stock (x of y selctable)";}s:24:"sBasketPremiumDifference";a:1:{s:5:"value";s:36:"You almost reached this premium! Add";}s:19:"sAGBTextPaymentform";a:1:{s:5:"value";s:42:"I read the general terms and conditions...";}s:14:"sBasketInquiry";a:1:{s:5:"value";s:19:"Solicit a quotation";}s:21:"sArticleCompareDetail";a:1:{s:5:"value";s:15:"Compare article";}}' AND (objectlanguage = 2 OR objectlanguage = 'en') AND objecttype = 'config_snippets';
            -- 68
            UPDATE s_core_translations SET objectdata = 'a:2:{s:7:"subject";s:18:"Your voucher order";s:7:"content";s:230:"Hello {$sUser.billing_firstname}{$sUser.billing_lastname},\n \nThank you for your order. (Number: {$sOrder.ordernumber}).\n\nPlease find your voucher code attached to this email.\n\n{$EventResult.code}\n\nBest regards,\n\nYour Shopware team";}'
                    WHERE objectdata = 'a:2:{s:7:"subject";s:18:"Your voucher order";s:7:"content";s:231:"Hello {$sUser.billing_firstname}{$sUser.billing_lastname},\n \nThank you for your order. (Number: {$sOrder.ordernumber}).\n\nPlease find your voucher code attached to this e-mail.\n\n{$EventResult.code}\n\nBest regards,\n\nYour Shopware team";}' AND (objectlanguage = 2 OR objectlanguage = 'en') AND objecttype = 'config_mails';
            -- 70
            UPDATE s_core_translations SET objectdata = 'a:3:{s:7:"subject";s:37:"Your registration has been successful";s:7:"content";s:291:"Hello {salutation} {firstname} {lastname},\n \nThank you for your registration with our Shop.\n \nYou will gain access via the email address {sMAIL}\nand the password you have chosen.\n \nYou can have your password sent to you by email anytime. \n \nBest regards\n \nYour team of {config name=shopName}";s:11:"contentHtml";s:354:"<div>\nHello {salutation} {firstname} {lastname},<br/><br/>\n \nThank you for your registration with our Shop.<br/><br/>\n \nYou will gain access via the email address {sMAIL} and the password you have chosen.<br/><br/>\n \nYou can have your password sent to you by email anytime. <br/><br/>\n \nBest regards<br/><br/>\n \nYour team of {config name=shopName}\n</div>";}'
                    WHERE objectdata = 'a:3:{s:7:"subject";s:37:"Your registration has been successful";s:7:"content";s:293:"Hello {salutation} {firstname} {lastname},\n \nThank you for your registration with our Shop.\n \nYou will gain access via the e-mail address {sMAIL}\nand the password you have chosen.\n \nYou can have your password sent to you by e-mail anytime. \n \nBest regards\n \nYour team of {config name=shopName}";s:11:"contentHtml";s:356:"<div>\nHello {salutation} {firstname} {lastname},<br/><br/>\n \nThank you for your registration with our Shop.<br/><br/>\n \nYou will gain access via the e-mail address {sMAIL} and the password you have chosen.<br/><br/>\n \nYou can have your password sent to you by e-mail anytime. <br/><br/>\n \nBest regards<br/><br/>\n \nYour team of {config name=shopName}\n</div>";}' AND (objectlanguage = 2 OR objectlanguage = 'en') AND objecttype = 'config_mails';

            -- 71
            UPDATE s_core_translations SET objectdata = 'a:3:{s:7:"subject";s:28:"Your order with the demoshop";s:7:"content";s:1802:"Hello {$billingaddress.firstname} {$billingaddress.lastname},\n \nThank you for your order at {config name=shopName} (Number: {$sOrderNumber}) on {$sOrderDay} at {$sOrderTime}.\nInformation on your order:\n \nPos. Art.No.              Quantities         Price        Total\n{foreach item=details key=position from=$sOrderDetails}\n{$position+1|fill:4} {$details.ordernumber|fill:20} {$details.quantity|fill:6} {$details.price|padding:8} EUR {$details.amount|padding:8} EUR\n{$details.articlename|wordwrap:49|indent:5}\n{/foreach}\n \nShipping costs: {$sShippingCosts}\nTotal net: {$sAmountNet}\n{if !$sNet}\nTotal gross: {$sAmount}\n{/if}\n \nSelected payment type: {$additional.payment.description}\n{$additional.payment.additionaldescription}\n{if $additional.payment.name == "debit"}\nYour bank connection:\nAccount number: {$sPaymentTable.account}\nBIN:{$sPaymentTable.bankcode}\nWe will withdraw the money from your bank account within the next days.\n{/if}\n{if $additional.payment.name == "prepayment"}\n \nOur bank connection:\nAccount: ###\nBIN: ###\n{/if}\n \n{if $sComment}\nYour comment:\n{$sComment}\n{/if}\n \nBilling address:\n{$billingaddress.company}\n{$billingaddress.firstname} {$billingaddress.lastname}\n{$billingaddress.street} {$billingaddress.streetnumber}\n{$billingaddress.zipcode} {$billingaddress.city}\n{$billingaddress.phone}\n{$additional.country.countryname}\n \nShipping address:\n{$shippingaddress.company}\n{$shippingaddress.firstname} {$shippingaddress.lastname}\n{$shippingaddress.street} {$shippingaddress.streetnumber}\n{$shippingaddress.zipcode} {$shippingaddress.city}\n{$additional.country.countryname}\n \n{if $billingaddress.ustid}\nYour VAT-ID: {$billingaddress.ustid}\nIn case of a successful order and if you are based in one of the EU countries, you will receive your goods exempt from turnover tax. \n{/if}\n ";s:11:"contentHtml";s:3556:"<div style="font-family:arial; font-size:12px;">\n \n<p>Hello {$billingaddress.firstname} {$billingaddress.lastname},<br/><br/>\n \nThank you for your order with {config name=shopName} (Nummer: {$sOrderNumber}) on {$sOrderDay} at {$sOrderTime}.\n<br/>\n<br/>\n<strong>Information on your order:</strong></p>\n  <table width="80%" border="0" style="font-family:Arial, Helvetica, sans-serif; font-size:10px;">\n    <tr>\n      <td bgcolor="#F7F7F2" style="border-bottom:1px solid #cccccc;"><strong>Art.No.</strong></td>\n      <td bgcolor="#F7F7F2" style="border-bottom:1px solid #cccccc;"><strong>Pos.</strong></td>\n      <td bgcolor="#F7F7F2" style="border-bottom:1px solid #cccccc;"><strong>Art-Nr.</strong></td>\n      <td bgcolor="#F7F7F2" style="border-bottom:1px solid #cccccc;"><strong>Quantities</strong></td>\n      <td bgcolor="#F7F7F2" style="border-bottom:1px solid #cccccc;"><strong>Price</strong></td>\n      <td bgcolor="#F7F7F2" style="border-bottom:1px solid #cccccc;"><strong>Total</strong></td>\n    </tr>\n \n    {foreach item=details key=position from=$sOrderDetails}\n    <tr>\n      <td rowspan="2" style="border-bottom:1px solid #cccccc;">{if $details.image.src.1}<img src="{$details.image.src.1}" alt="{$details.articlename}" />{else} {/if}</td>\n      <td>{$position+1|fill:4} </td>\n      <td>{$details.ordernumber|fill:20}</td>\n      <td>{$details.quantity|fill:6}</td>\n      <td>{$details.price|padding:8}{$sCurrency}</td>\n      <td>{$details.amount|padding:8} {$sCurrency}</td>\n    </tr>\n    <tr>\n      <td colspan="5" style="border-bottom:1px solid #cccccc;">{$details.articlename|wordwrap:80|indent:4}</td>\n    </tr>\n    {/foreach}\n \n  </table>\n \n<p>\n  <br/>\n  <br/>\n    Shipping costs:: {$sShippingCosts}<br/>\n    Total net: {$sAmountNet}<br/>\n    {if !$sNet}\n    Total gross: {$sAmount}<br/>\n    {/if}\n  <br/>\n  <br/>\n    <strong>Selected payment type:</strong> {$additional.payment.description}<br/>\n    {$additional.payment.additionaldescription}\n    {if $additional.payment.name == "debit"}\n    Your bank connection:<br/>\n    Account number: {$sPaymentTable.account}<br/>\n    BIN:{$sPaymentTable.bankcode}<br/>\n    We will withdraw the money from your bank account within the next days.<br/>\n    {/if}\n  <br/>\n  <br/>\n    {if $additional.payment.name == "prepayment"}\n    Our bank connection:<br/>\n    {config name=bankAccount}\n    {/if} \n  <br/>\n  <br/>\n    <strong>Selected dispatch:</strong> {$sDispatch.name}<br/>{$sDispatch.description}\n</p>\n<p>\n  {if $sComment}\n    <strong>Your comment:</strong><br/>\n    {$sComment}<br/>\n  {/if} \n  <br/>\n  <br/>\n    <strong>Billing address:</strong><br/>\n    {$billingaddress.company}<br/>\n    {$billingaddress.firstname} {$billingaddress.lastname}<br/>\n    {$billingaddress.street} {$billingaddress.streetnumber}<br/>\n    {$billingaddress.zipcode} {$billingaddress.city}<br/>\n    {$billingaddress.phone}<br/>\n    {$additional.country.countryname}<br/>\n  <br/>\n  <br/>\n    <strong>Shipping address:</strong><br/>\n    {$shippingaddress.company}<br/>\n    {$shippingaddress.firstname} {$shippingaddress.lastname}<br/>\n    {$shippingaddress.street} {$shippingaddress.streetnumber}<br/>\n    {$shippingaddress.zipcode} {$shippingaddress.city}<br/>\n    {$additional.countryShipping.countryname}<br/>\n  <br/>\n    {if $billingaddress.ustid}\n    Your VAT-ID: {$billingaddress.ustid}<br/>\n    In case of a successful order and if you are based in one of the EU countries, you will receive your goods exempt from turnover tax. \n    {/if}\n  <br/>\n  <br/>\n\n    Your Team of {config name=shopName}<br/>\n</p>\n</div>";}'
                    WHERE objectdata = 'a:3:{s:7:"subject";s:28:"Your order with the demoshop";s:7:"content";s:1802:"Hello {$billingaddress.firstname} {$billingaddress.lastname},\n \nThank you for your order at {config name=shopName} (Nummer: {$sOrderNumber}) on {$sOrderDay} at {$sOrderTime}.\nInformation on your order:\n \nPos. Art.No.              Quantities         Price        Total\n{foreach item=details key=position from=$sOrderDetails}\n{$position+1|fill:4} {$details.ordernumber|fill:20} {$details.quantity|fill:6} {$details.price|padding:8} EUR {$details.amount|padding:8} EUR\n{$details.articlename|wordwrap:49|indent:5}\n{/foreach}\n \nShipping costs: {$sShippingCosts}\nTotal net: {$sAmountNet}\n{if !$sNet}\nTotal gross: {$sAmount}\n{/if}\n \nSelected payment type: {$additional.payment.description}\n{$additional.payment.additionaldescription}\n{if $additional.payment.name == "debit"}\nYour bank connection:\nAccount number: {$sPaymentTable.account}\nBIN:{$sPaymentTable.bankcode}\nWe will withdraw the money from your bank account within the next days.\n{/if}\n{if $additional.payment.name == "prepayment"}\n \nOur bank connection:\nAccount: ###\nBIN: ###\n{/if}\n \n{if $sComment}\nYour comment:\n{$sComment}\n{/if}\n \nBilling address:\n{$billingaddress.company}\n{$billingaddress.firstname} {$billingaddress.lastname}\n{$billingaddress.street} {$billingaddress.streetnumber}\n{$billingaddress.zipcode} {$billingaddress.city}\n{$billingaddress.phone}\n{$additional.country.countryname}\n \nShipping address:\n{$shippingaddress.company}\n{$shippingaddress.firstname} {$shippingaddress.lastname}\n{$shippingaddress.street} {$shippingaddress.streetnumber}\n{$shippingaddress.zipcode} {$shippingaddress.city}\n{$additional.country.countryname}\n \n{if $billingaddress.ustid}\nYour VAT-ID: {$billingaddress.ustid}\nIn case of a successful order and if you are based in one of the EU countries, you will receive your goods exempt from turnover tax. \n{/if}\n ";s:11:"contentHtml";s:3556:"<div style="font-family:arial; font-size:12px;">\n \n<p>Hello {$billingaddress.firstname} {$billingaddress.lastname},<br/><br/>\n \nThank you for your order with {config name=shopName} (Nummer: {$sOrderNumber}) on {$sOrderDay} at {$sOrderTime}.\n<br/>\n<br/>\n<strong>Information on your order:</strong></p>\n  <table width="80%" border="0" style="font-family:Arial, Helvetica, sans-serif; font-size:10px;">\n    <tr>\n      <td bgcolor="#F7F7F2" style="border-bottom:1px solid #cccccc;"><strong>Art.No.</strong></td>\n      <td bgcolor="#F7F7F2" style="border-bottom:1px solid #cccccc;"><strong>Pos.</strong></td>\n      <td bgcolor="#F7F7F2" style="border-bottom:1px solid #cccccc;"><strong>Art-Nr.</strong></td>\n      <td bgcolor="#F7F7F2" style="border-bottom:1px solid #cccccc;"><strong>Quantities</strong></td>\n      <td bgcolor="#F7F7F2" style="border-bottom:1px solid #cccccc;"><strong>Price</strong></td>\n      <td bgcolor="#F7F7F2" style="border-bottom:1px solid #cccccc;"><strong>Total</strong></td>\n    </tr>\n \n    {foreach item=details key=position from=$sOrderDetails}\n    <tr>\n      <td rowspan="2" style="border-bottom:1px solid #cccccc;">{if $details.image.src.1}<img src="{$details.image.src.1}" alt="{$details.articlename}" />{else} {/if}</td>\n      <td>{$position+1|fill:4} </td>\n      <td>{$details.ordernumber|fill:20}</td>\n      <td>{$details.quantity|fill:6}</td>\n      <td>{$details.price|padding:8}{$sCurrency}</td>\n      <td>{$details.amount|padding:8} {$sCurrency}</td>\n    </tr>\n    <tr>\n      <td colspan="5" style="border-bottom:1px solid #cccccc;">{$details.articlename|wordwrap:80|indent:4}</td>\n    </tr>\n    {/foreach}\n \n  </table>\n \n<p>\n  <br/>\n  <br/>\n    Shipping costs:: {$sShippingCosts}<br/>\n    Total net: {$sAmountNet}<br/>\n    {if !$sNet}\n    Total gross: {$sAmount}<br/>\n    {/if}\n  <br/>\n  <br/>\n    <strong>Selected payment type:</strong> {$additional.payment.description}<br/>\n    {$additional.payment.additionaldescription}\n    {if $additional.payment.name == "debit"}\n    Your bank connection:<br/>\n    Account number: {$sPaymentTable.account}<br/>\n    BIN:{$sPaymentTable.bankcode}<br/>\n    We will withdraw the money from your bank account within the next days.<br/>\n    {/if}\n  <br/>\n  <br/>\n    {if $additional.payment.name == "prepayment"}\n    Our bank connection:<br/>\n    {config name=bankAccount}\n    {/if} \n  <br/>\n  <br/>\n    <strong>Selected dispatch:</strong> {$sDispatch.name}<br/>{$sDispatch.description}\n</p>\n<p>\n  {if $sComment}\n    <strong>Your comment:</strong><br/>\n    {$sComment}<br/>\n  {/if} \n  <br/>\n  <br/>\n    <strong>Billing address:</strong><br/>\n    {$billingaddress.company}<br/>\n    {$billingaddress.firstname} {$billingaddress.lastname}<br/>\n    {$billingaddress.street} {$billingaddress.streetnumber}<br/>\n    {$billingaddress.zipcode} {$billingaddress.city}<br/>\n    {$billingaddress.phone}<br/>\n    {$additional.country.countryname}<br/>\n  <br/>\n  <br/>\n    <strong>Shipping address:</strong><br/>\n    {$shippingaddress.company}<br/>\n    {$shippingaddress.firstname} {$shippingaddress.lastname}<br/>\n    {$shippingaddress.street} {$shippingaddress.streetnumber}<br/>\n    {$shippingaddress.zipcode} {$shippingaddress.city}<br/>\n    {$additional.countryShipping.countryname}<br/>\n  <br/>\n    {if $billingaddress.ustid}\n    Your VAT-ID: {$billingaddress.ustid}<br/>\n    In case of a successful order and if you are based in one of the EU countries, you will receive your goods exempt from turnover tax. \n    {/if}\n  <br/>\n  <br/>\n\n    Your Team of {config name=shopName}<br/>\n</p>\n</div>";}' AND (objectlanguage = 2 OR objectlanguage = 'en') AND objecttype = 'config_mails';

            -- 77
            UPDATE s_core_translations SET objectdata = 'a:2:{s:7:"subject";s:41:"Your trader account has not been accepted";s:7:"content";s:307:"Dear customer,\n\nThank you for your interest in our trade prices. Unfortunately, we do not have a trading license yet so that we cannot accept you as a trader. \n\nIn case of further questions please do not hesitate to contact us via telephone, fax or email. \n\nBest regards\n\nYour Team of {config name=shopName}";}'
                    WHERE objectdata = 'a:2:{s:7:"subject";s:40:"Your trader acount has not been accepted";s:7:"content";s:307:"Dear customer,\n\nThank you for your interest in our trade prices. Unfortunately, we do not have a trading license yet so that we cannot accept you as a trader. \n\nIn case of further questions please do not heitate to contact us via telephone, fax or e-mail. \n\nBest regards\n\nYour Team of {config name=shopName}";}' AND (objectlanguage = 2 OR objectlanguage = 'en') AND objecttype = 'config_mails';

            -- 86
            UPDATE s_core_translations SET objectdata = 'a:2:{s:7:"subject";s:38:"Please confirm your email notification";s:7:"content";s:237:"Hello, \n\nThank you for signing up for the automatic email notification for the article {$sArticleName}. \nPlease confirm the notification by clicking the following link:\n\n{$sConfirmLink} \n\nBest regards\n\nYour Team of {config name=shopName}";}'
                    WHERE objectdata = 'a:2:{s:7:"subject";s:39:"Please confirm your e-mail notification";s:7:"content";s:237:"Hello, \n\nThank you for signing up for the automatic email notification for the article {$sArticleName}. \nPlease confirm the notification by clicking the following link:\n\n{$sConfirmLink} \n\nBest regards\n\nYour Team of {config name=shopName}";}' AND (objectlanguage = 2 OR objectlanguage = 'en') AND objecttype = 'config_mails';


EOD;
        $this->addSql($sql);
    }
}
